/**
 * 出勤
 */
import moment = require("moment");
import { selectDataToTableAssociation } from "../model/findData";
import { ASKFORLEAVETYPE, STATED, TABLENAMEENUM } from "../config/enum";
import { changeEnumValue } from "../util/piecemeal";


/**
 * 出勤列表
 * @param year 
 * @param month 
 * @returns 
 */
export async function getAttendanceData(year:number, month:number) {
    let startTime = moment(`${year}-${month >=10 ? ''+month : '0'+month}-01 00:00:00`).format("YYYY-MM-DD") + ' 00:00:00';
    let endTime = moment(`${year}-${month >=10 ? ''+month : '0'+month}-01 00:00:00`).add(1, 'months').format("YYYY-MM-DD") + ' 00:00:00';

    /**查询工时 */
    let selectParam = {
        dateKey:{"%between%":[startTime, endTime]}
    };
    let includeConf = {};
    includeConf[TABLENAMEENUM.用户表] = ["name"];
    let workLog = await  selectDataToTableAssociation(TABLENAMEENUM.工时表, includeConf, selectParam, ["dateKey", "time"]);

    //获取日历标题
    let tileList = [{label:"姓名", prop:"name", index:0}];
    let dataCount = moment(startTime).daysInMonth();
    for (let i = 1; i <= dataCount; i++) {
        let dateKey = moment(`${year}-${month >=10 ? ''+month : '0'+month}-${i >=10 ? ''+i : '0'+i} 00:00:00`).format("MM-DD");
        tileList.push({label:dateKey, prop:dateKey, index:i});
    }

    let dataMap = {};
    workLog.forEach(info => {
        let {dateKey, user, time} = info;
        let name = user.name;
        let key = moment(dateKey).format("MM-DD");
        if (!dataMap[name]) dataMap[name] = {name};
        if (!dataMap[name][key] )  dataMap[name][key] = 0;
        dataMap[name][key] += time;
    });

    /**查询请假 */
    let askSelectParam = {
        endTime:{"%gt%":startTime},
        state:STATED.是
    };
    let askIncludeConf = {};
    askIncludeConf[TABLENAMEENUM.用户表] = ["name"];
    let askLog = await  selectDataToTableAssociation(TABLENAMEENUM.请假, askIncludeConf, askSelectParam, ["startTime", "endTime", "time", "type", "day"]);
    askLog.forEach(info => {
        let {user, time, startTime, endTime, type, day} = info;
        if (!dataMap[user.name]) dataMap[user.name] = {name:user.name};
        let askDay = moment(endTime).diff(moment(startTime), 'days');
        if (askDay > 0) {
            for (let i = 0; i < askDay; i++) {
                let dayKey = moment(startTime).add(i, 'days').format("MM-DD");
                if (!dataMap[user.name][dayKey]) dataMap[user.name][dayKey] = `${changeEnumValue(ASKFORLEAVETYPE, type)}`;
            }
        } else if (askDay == 0) {
            let dayKey = moment(startTime).format("MM-DD");
            dataMap[user.name][dayKey] = `${changeEnumValue(ASKFORLEAVETYPE, type)}${(day*8)+time}h`;
        }
    });

    let dataList = Object.values(dataMap);

    return {dataList, tileList};
}