/**
 * 统计路由
 */

import * as asyncHandler from 'express-async-handler';
import * as statsBiz from '../biz/stats';
import moment = require('moment');
import { eccReqParamater } from '../tools/eccParam';

export function setRouter(httpServer) {
    /**项目工时统计 */
    httpServer.post('/stats/working/allproject', asyncHandler(allProject));
    httpServer.post('/stats/working/monthproject', asyncHandler(monthProject));
    httpServer.post('/stats/working/weekproject', asyncHandler(weekProject));
    /**本月工时日志 */
    httpServer.post('/stats/working/month/project', asyncHandler(thisMonthProject));
    httpServer.post('/stats/working/month/project/member', asyncHandler(thisMonthProjectAndUser));
    /**部门统计 */
    httpServer.post('/stats/department/working', asyncHandler(departmentWorkinglog));
    httpServer.post('/stats/department/overtimeandask', asyncHandler(departmentAskForLeaveAndOverTime));
    httpServer.post('/stats/department/departmentproject', asyncHandler(departmentProject));
    httpServer.post('/stats/department/departmentprojectcalendar', asyncHandler(departmentProjectCalendar));
}


async function allProject(req, res) {
    let result = await statsBiz.allProjectData();
    res.success(result);
}


async function monthProject(req, res) {
    let st = moment().subtract(30,'day').format("YYYY-MM-DD")+' 00:00:00';
    let et = moment().format("YYYY-MM-DD")+' 00:00:00';
    let result = await statsBiz.timeProjectData(st, et);
    res.success(result);
}

async function weekProject(req, res) {
    let thisWeekDay = moment().weekday();
    let st = moment().subtract(1,'week').subtract(thisWeekDay, 'days').format("YYYY-MM-DD")+' 00:00:00';
    let et = moment(st).add(7,'days').format("YYYY-MM-DD")+' 00:00:00';
    let result = await statsBiz.timeProjectData(st, et);
    res.success(result);
}


async function departmentWorkinglog(req, res) {
    let  reqConf = {departmentId: 'Number'};
    let { departmentId } = eccReqParamater(reqConf, req.body, []); 
    let result = await statsBiz.departmentWorkinglogData(departmentId);
    res.success(result);
}

async function departmentAskForLeaveAndOverTime(req, res) {
    let  reqConf = {departmentId: 'Number'};
    let { departmentId } = eccReqParamater(reqConf, req.body, []); 
    let result = await statsBiz.departmentAskForLeaveAndOverTimeData(departmentId);
    res.success(result);
}

async function departmentProject(req, res) {
    let  reqConf = {departmentId: 'Number'};
    let { departmentId } = eccReqParamater(reqConf, req.body, []); 
    let result = await statsBiz.departmentProjectData(departmentId);
    res.success(result);
}

async function departmentProjectCalendar(req, res) {
    let  reqConf = {departmentId: 'Number'};
    let { departmentId } = eccReqParamater(reqConf, req.body, []); 
    let result = await statsBiz.departmentProjectCalendarData(departmentId);
    res.success(result);
}

async function thisMonthProject(req, res) {
    let reqConf = {projectName: 'String', departmentId:'Number'};
    let { projectName, departmentId } = eccReqParamater(reqConf, req.body, []);
    let result = await statsBiz.getThisMonthProject(projectName, departmentId);
    res.success(result);
}

async function thisMonthProjectAndUser(req, res) {
    let reqConf = {projectName: 'String', departmentId:'Number', userName:"String"};
    let { projectName, departmentId, userName } = eccReqParamater(reqConf, req.body, []);
    let result = await statsBiz.getThisMonthProjectAndName(projectName, departmentId, userName);
    res.success(result);
}