/**
 * 公共资源路由
 */

import * as asyncHandler from 'express-async-handler';
import { ASKFORLEAVETYPE, WORKLOGADMINTYPE } from '../config/enum';
import { projectListForSelect } from '../biz/project';

export function setRouter(httpServer) {
    httpServer.post('/public/askforleavetype', asyncHandler(askForLeave));
    httpServer.post('/public/projectlist', asyncHandler(projectList));
    httpServer.post('/public/adminworkingtype', asyncHandler(adminWorkingType));
}


async function adminWorkingType(req, res) {
    let dataList = [];
    for (let key in WORKLOGADMINTYPE) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            dataList.push({key, value:WORKLOGADMINTYPE[key]});
        }
    }
    res.success({dataList});
}

/**
 * @param req 
 * @param res 
 */
async function askForLeave(req, res) {
    let dataList = [];
    for (let key in ASKFORLEAVETYPE) {
        let anyKey:any = key;
        if (isNaN(anyKey)) {
            dataList.push({key, value:ASKFORLEAVETYPE[key]});
        }
    }
    res.success({dataList});
}


/**
 * @param req 
 * @param res 
 */
async function projectList(req, res) {
    let result = await projectListForSelect();
    res.success(result);
}

