/**
 * 项目路由
 */

import * as asyncHandler from 'express-async-handler';
import { checkFuHuaQiToken } from '../middleware/user';
import * as projectBiz from '../biz/project';
import { eccReqParamater } from '../tools/eccParam';
export function setRouter(httpServer) {
    httpServer.post('/project/find', checkFuHuaQiToken, asyncHandler(find));
    httpServer.post('/project/add', checkFuHuaQiToken, asyncHandler(add));
    httpServer.post('/project/update', checkFuHuaQiToken, asyncHandler(update));
}

/**
 * 工时管理 查询填报的工时
 * @param req 
 * @param res 
 */
async function find(req, res) {
    let userId = req.headers.userid;
    let result = await projectBiz.allProjectList();
    res.success(result);
}

async function add(req, res) {
    let userId = req.headers.userid;
    let  reqConf = {id: 'String', name: 'String', controller:'String'};
    let { id, name, controller } = eccReqParamater(reqConf, req.body, ['workLog']);

    let result = await projectBiz.addProjectData(id, name, controller);
    res.success(result);
}


async function update(req, res) {
    let userId = req.headers.userid;
    let  reqConf = {id: 'String', name: 'String', controller:'String'};
    let { id, name, controller } = eccReqParamater(reqConf, req.body, ['workLog']);

    let result = await projectBiz.updateProjectData(id, name, controller);
    res.success(result);
}