/**
 * 加班路由
 */

import * as asyncHandler from 'express-async-handler';
import { checkFuHuaQiToken } from '../middleware/user';
import { addOvertimeLog, approveOverTime, approveOverTimeList, deleteOvertimeLog, overtimeList, updateOvertimeLog } from '../biz/overtime';
import { eccReqParamater } from '../tools/eccParam';

export function setRouter(httpServer) {
    httpServer.post('/overtime/find', checkFuHuaQiToken, asyncHandler(find));
    httpServer.post('/overtime/add', checkFuHuaQiToken, asyncHandler(add));
    httpServer.post('/overtime/del', checkFuHuaQiToken, asyncHandler(del));
    httpServer.post('/overtime/update', checkFuHuaQiToken, asyncHandler(update));

    httpServer.post('/overtime/approve', checkFuHuaQiToken, asyncHandler(approve));
    httpServer.post('/overtime/approvelist', checkFuHuaQiToken, asyncHandler(approveList));
}



/**
 * 工时管理 查询填报的工时
 * @param req 
 * @param res 
 */
async function find(req, res) {
    let userId = req.headers.userid;
    let result = await overtimeList(userId);
    res.success(result);
}


/**
 * 
 * @param req 工时管理 添加
 * @param res 
 */
async function add(req, res) {
    let userId = req.headers.userid;
    let  reqConf = {time: 'Number', projectId: 'String', date:'String', workLog:"String"};
    let { time, projectId, date, workLog} = eccReqParamater(reqConf, req.body, ['workLog']);

    let result = await addOvertimeLog(userId, time, projectId, date, workLog);
    res.success(result);
}


/**
 * 工时管理 删除
 * @param req 
 * @param res 
 */
async function del(req, res) {
    let userId = req.headers.userid;
    let { id } = req.body;
    let result = await deleteOvertimeLog(id);
    res.success(result);
}


/**
 * 工时管理 修改
 * @param req 
 * @param res 
 */
async function update(req, res) {
    let userId = req.headers.userid;
    let  reqConf = {id:"String", time: 'Number', projectId: 'String', workLog:"String"};
    let {id, time, projectId, workLog} = eccReqParamater(reqConf, req.body);

    let result = await updateOvertimeLog(id, userId, time, projectId, workLog);
    res.success(result);
}

async function approve(req, res) {
    let userId = req.headers.userid;
    let  reqConf = {id:"String", type:"Number", notPassingStr:"String"};
    let {id, type, notPassingStr} = eccReqParamater(reqConf, req.body);

    let result = await approveOverTime(id, type, notPassingStr);
    res.success(result);
}

async function approveList(req, res) {
    let userId = req.headers.userid;

    let result = await approveOverTimeList(userId);
    res.success(result);
}