/**
 * 成员
 */

import * as asyncHandler from 'express-async-handler';
import { checkFuHuaQiToken } from '../middleware/user';
import * as memberBiz from '../biz/member';
import { eccReqParamater } from '../tools/eccParam';

export function setRouter(httpServer) {
    httpServer.post('/member/personnel/list', checkFuHuaQiToken, asyncHandler(memberList));
    httpServer.post('/member/personnel/update', checkFuHuaQiToken, asyncHandler(updateInfo));
}


/**
 * 成员列表
 * @param req 
 * @param res 
 */
async function memberList(req, res) {
    let result = await memberBiz.getMemberList();
    res.success(result);
}

/**
 * 更新入职时间
 * @param req 
 * @param res 
 */
async function updateInfo(req, res) {
    let  reqConf = {userId: 'Number', ed: 'String'};
    let { userId, ed} = eccReqParamater(reqConf, req.body, ["day", "time"]);

    let result = await memberBiz.updateMemberData(userId, ed);

    res.success(result);
}