/**
 * 出勤路由
 */

import * as asyncHandler from 'express-async-handler';
import { checkFuHuaQiToken } from '../middleware/user';
import * as attendanceBiz from '../biz/attendance';
import { eccReqParamater } from '../tools/eccParam';

export function setRouter(httpServer) {
    httpServer.post('/attendance/find', checkFuHuaQiToken, asyncHandler(find));
    httpServer.post('/attendance/output', checkFuHuaQiToken, asyncHandler(outPut));
}


async function find(req, res) {
    let  reqConf = { year:"Number", month:"Number"};
    let {year, month} = eccReqParamater(reqConf, req.body, []);

    let result = await attendanceBiz.getAttendanceData(year, month);
    res.success(result);
}


async function outPut(req, res) {
    let  reqConf = { year:"Number", month:"Number"};
    let {year, month} = eccReqParamater(reqConf, req.body, []);

    let result = await attendanceBiz.getAttendanceData(year, month);
    res.success(result);
}
