/**
 * 请假
 */

import * as asyncHandler from 'express-async-handler';
import * as askForLeaveBiz from '../biz/askForLeave';
import { checkFuHuaQiToken } from '../middleware/user';
import { eccReqParamater } from '../tools/eccParam';
import { memberSelectList } from '../biz/member';

export function setRouter(httpServer) {
    httpServer.post('/askforleave/add', checkFuHuaQiToken, asyncHandler(add));
    httpServer.post('/askforleave/list', checkFuHuaQiToken, asyncHandler(list));
    httpServer.post('/askforleave/del', checkFuHuaQiToken, asyncHandler(del));
    httpServer.post('/askforleave/update', checkFuHuaQiToken, asyncHandler(update));
    /**审批 */
    httpServer.post('/askforleave/approve', checkFuHuaQiToken, asyncHandler(approve));
    httpServer.post('/askforleave/approvelist', checkFuHuaQiToken, asyncHandler(approveList));

    /**人事用请假列表 */
    httpServer.post('/askforleave/personnel/list', checkFuHuaQiToken, asyncHandler(personnelList));
    httpServer.post('/askforleave/personnel/membernamelist', checkFuHuaQiToken, asyncHandler(memberNameList));
    httpServer.post('/askforleave/personnel/output', checkFuHuaQiToken, asyncHandler(outPutData));

}

async function add(req, res) {
    let userId = req.headers.userid;
    let userInfo = req.headers.userinfo;
    let  reqConf = {des: 'String', startTime: 'String', endTime: 'String', type:'Number', day:"Number", time:"Number"};
    let { des, startTime, endTime, type, day, time } = eccReqParamater(reqConf, req.body, ["day", "time"]);
    
    let result = await askForLeaveBiz.addAskForLeaveLog(userId, userInfo, des, startTime, endTime, type, day, time);
    res.success(result);
}


async function list(req, res) {
    let userId = req.headers.userid;

    let result = await askForLeaveBiz.myAskForLeaveList(userId);
    res.success(result);
}

/**
 *  删除
 * @param req 
 * @param res 
 */
async function del(req, res) {
    let userId = req.headers.userid;
    let { id } = req.body;
    let result = await askForLeaveBiz.deleteAskForLeave(id);
    res.success(result);
}


/**
 *  修改
 * @param req 
 * @param res 
 */
async function update(req, res) {
    let userId = req.headers.userid;
    let  reqConf = {id:'String', des: 'String', startTime: 'String', endTime: 'String', type:'Number', day:"Number", time:"Number"};
    let { id, des, startTime, endTime, type, day, time } = eccReqParamater(reqConf, req.body, ["day", "time"]);

    let result = await askForLeaveBiz.updateAskForLeaveLog(id, userId, des, startTime, endTime, type, day, time);
    res.success(result);
}

async function approve(req, res) {
    let userId = req.headers.userid;
    let  reqConf = {id:"String", type:"Number", notPassingStr:"String"};
    let {id, type, notPassingStr} = eccReqParamater(reqConf, req.body);

    let result = await askForLeaveBiz.approveAskForLeave(id, type, notPassingStr);
    res.success(result);
}

async function approveList(req, res) {
    let userId = req.headers.userid;

    let result = await askForLeaveBiz.approveAskForLeaveList(userId);
    res.success(result);
}


async function personnelList(req, res) {
    // let userId = req.headers.userid;

    let  reqConf = {page:"Number", startTime:"String", endTime:"String", userId:"Number"};
    let {page, userId, startTime, endTime} = eccReqParamater(reqConf, req.body, ["startTime", "endTime", "userId"]);

    let result = await askForLeaveBiz.getPersonnelAFLList(page, userId, startTime, endTime);
    res.success(result);
}


async function memberNameList(req, res) {
    let userId = req.headers.userid;

    let result = await memberSelectList();
    res.success(result);
}


async function outPutData(req, res) {
    let  reqConf = { startTime:"String", endTime:"String", userId:"Number"};
    let {userId, startTime, endTime} = eccReqParamater(reqConf, req.body, ["startTime", "endTime", "userId"]);

    let result = await askForLeaveBiz.outPutPersonnelAFLList(userId, startTime, endTime);
    res.success(result);
}

