const Sequelize = require('sequelize');


export const TablesConfig = [
    {
        tableNameCn:'角色表',
        tableName:'role', 
        schema:{
            roleId:{
                type:Sequelize.INTEGER(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            roleName:{type:Sequelize.STRING(255), allowNull:false}, //登录账号
        },
        association: []
    },
    {
        tableNameCn:'部门表',
        tableName:'department', 
        schema:{
            departmentId:{
                type:Sequelize.INTEGER(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            name:{type:Sequelize.STRING(255), allowNull:false}, //部门名称
        },
        association: []
    },
    {
        tableNameCn:'用户表',
        tableName:'users',
        schema:{
            userId: {
                type:Sequelize.INTEGER(20), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            name: {type:Sequelize.STRING(255), allowNull:false}, //名称
            loginId: {type:Sequelize.STRING(255), allowNull:false}, //账号
            pwd: {type:Sequelize.STRING(255), allowNull:false}, //密码
            roleId: {type:Sequelize.INTEGER(20), allowNull:false, references:{
                model:'role',
                key:'roleId'
            }}, //角色id
            exchangeTime: {type:Sequelize.INTEGER(20), allowNull:false}, //调休剩余
            annualLeave: {type:Sequelize.INTEGER(20), allowNull:false}, //年假剩余
            departmentId: {type:Sequelize.INTEGER(20), allowNull:false, references:{
                model:'department',
                key:'departmentId'
            }}, //部门id
            token: {type:Sequelize.STRING(255)},
            tokenDate: {type:Sequelize.DATE},
            ed: {type:Sequelize.DATE}//入职时间
        },
        association: []
    },
    {
        tableNameCn:'项目表',
        tableName:'project', 
        schema:{
            projectId:{
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            name:{type:Sequelize.STRING(255)}, //项目名称
            contractId:{type:Sequelize.STRING(255)}, //合同编号
            controller:{type:Sequelize.STRING(255)}, //项目经理
            createTime:{type:Sequelize.DATE}, //创建时间
        },
        association: []
    },
    {
        tableNameCn:'加班',
        tableName:'overtime', 
        schema:{
            id:{
                type:Sequelize.STRING(244), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            projectId:{type:Sequelize.STRING(255), references:{
                model:'project',
                key:'projectId'
            }}, //
            userId:{type:Sequelize.INTEGER(20), references:{
                model:'users',
                key:'userId'
            }}, //
            dateKey:{type:Sequelize.DATE}, //
            time:{type:Sequelize.INTEGER(20), allowNull:false}, //
            state:{type:Sequelize.INTEGER(20), allowNull:false}, //
            approver:{type:Sequelize.INTEGER(20), allowNull:false}, //
            workLog:{type:Sequelize.STRING(255), allowNull:true},
            notPassing:{type:Sequelize.STRING(255), allowNull:true}//不通过理由
        },
        association: []
    },
    {
        tableNameCn:'请假',
        tableName:'askforleave', 
        schema:{
            id:{
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            des:{type:Sequelize.STRING(255)}, //描述
            startTime:{type:Sequelize.DATE}, //
            endTime:{type:Sequelize.DATE}, //
            userId:{type:Sequelize.INTEGER(20), references:{
                model:'users',
                key:'userId'
            }}, //
            approval:{type:Sequelize.INTEGER(20), allowNull:false}, //
            time:{type:Sequelize.INTEGER(20), allowNull:false}, //
            type:{type:Sequelize.INTEGER(20), allowNull:false}, //
            day:{type:Sequelize.INTEGER(20), allowNull:false}, //
            state:{type:Sequelize.INTEGER(20), allowNull:false}, //
            notPassing:{type:Sequelize.STRING(255), allowNull:true},//不通过理由
            dateKey:{type:Sequelize.DATE} //
        },
        association: [
          
        ]
    },
    {
        tableNameCn:'工时表',
        tableName:'workinglog', 
        schema:{
            id:{
                type:Sequelize.STRING(255), //表示属性的数据类型
                allowNull:false, //表示当前列是否允许为空， false表示该列不能为空
                primaryKey:true, //表示主键
                unique:true //表示该列的值必须唯一
            },
            projectId:{type:Sequelize.STRING(255), references:{
                model:'project',
                key:'projectId'
            }}, //
            userId:{type:Sequelize.INTEGER(20), references:{
                model:'users',
                key:'userId'
            }}, //
            time:{type:Sequelize.INTEGER(20), allowNull:false}, //
            dateKey:{type:Sequelize.DATE}, //
            isOutside:{type:Sequelize.INTEGER(20)}, //
            workLog:{type:Sequelize.STRING(255)}, //描述
        },
        association: [
        ]
    }
]; 