/**
 * 项目
 */

import { TABLENAMEENUM } from "../config/enum";
import { ERRORENUM } from "../config/errorEnum";
import { addData } from "../model/addData";
import { selectDataListByParam, selectOneDataByParam } from "../model/findData";
import { updateManyData } from "../model/updateData";
import { BizError } from "../util/bizError";
import { getDBTime } from "../util/myTools";




/**
 * 项目下拉框
 * @returns 
 */
export async function projectListForSelect() {
    let projectList = await selectDataListByParam(TABLENAMEENUM.项目表, {}, ["projectId", "name"]);
    let dataList = [];
    projectList.forEach(info => {
        let {projectId, name} = info;
        dataList.push( {id:projectId, name});
    });

    return {dataList:dataList}
}


/**
 * 所有项目列表
 * @returns 
 */
export async function allProjectList() {
    let projectList = await await selectDataListByParam(TABLENAMEENUM.项目表, {}, ["projectId", "projectId", "name", "controller", "createTime"]);
   
    let dataList = [];
    projectList.forEach(info => {
        dataList.push({
            id:info.projectId,
            name:info.name,
            controller:info.controller||"",
            controllerStr:info.controller || "无",
            createTime:info.createTime ? new Date(info.createTime).valueOf() : 0
        });
    });
    dataList.sort( (a, b) => { return new Date(b.createTime  || 0).valueOf() - new Date(a.createTime  || 0).valueOf() });

    return {dataList};
}


/**
 * 创建新项目
 * @param id 
 * @param name 
 * @param controller 
 * @returns 
 */
export async function addProjectData(id:string, name:string, controller:string) {
    let projectInfo = await selectOneDataByParam(TABLENAMEENUM.项目表, {projectId:id}, ["projectId", "name"]);
    if (projectInfo.projectId) throw new BizError(ERRORENUM.项目ID已存在);

    await addData(TABLENAMEENUM.项目表, {projectId:id, name, controller, createTime:getDBTime() } );
    
    return {isSuccess:true, message:"添加成功"};
}


/**
 * 修改
 * @param id 
 * @param name 
 * @param controller 
 * @returns 
 */
export async function updateProjectData(id:string, name:string, controller:string) {
    let projectInfo = await selectOneDataByParam(TABLENAMEENUM.项目表, {projectId:id}, ["projectId", "name"]);
    if (!projectInfo.projectId) throw new BizError(ERRORENUM.目标数据已不存在);

    await updateManyData(TABLENAMEENUM.项目表, {projectId:id}, {name, controller});

    return {isSuccess:true, message:"修改成功"};
}