


import * as asyncHandler from 'express-async-handler';
import { get, post, postForm } from '../util/request';
var formidable = require("formidable");

const ApiConfig = {
    token:{type:"post", url:'/oauth/token', name:"获取token"},
    statistics:{type:"post", url:'/service/api/nmzx/statistics', name:"教师总数"},
    teachersex_count:{type:"post", url:'/service/api/nmzx/teachersex_count', name:"男女比例"},
    teacherage_count:{type:"post", url:'/service/api/nmzx/teacherage_count', name:"年龄分布"},
    teacherzzmm_count:{type:"post", url:'/service/api/nmzx/teacherzzmm_count', name:"教师政治面貌"},
    teacherzc_count:{type:"post", url:'/service/api/nmzx/teacherzc_count', name:"职称分布"},
    ggteacher_count:{type:"post", url:'/service/api/nmzx/ggteacher_count', name:"教师专业建设&组织部署"},
    teacher_hj:{type:"post", url:'/service/api/nmzx/teacher_hj', name:"国家级奖项，市级奖项，区级奖项，镇级奖项，校级奖项"},
    teacher_attendance:{type:"post", url:'/service/api/nmzx/teacher_attendance', name:"出勤考核"},
    teacher_score:{type:"post", url:'/service/api/nmzx/teacher_score', name:"学分管理"},
    subjects:{type:"post", url:'/service/api/nmzx/subject', name:"学科下拉数据"},
    teacher_info_get:{type:"get", url:'/service/api/nmzx/teacher_info_get', name:"教师基础信息 数据"},
    teacher_open:{type:"post", url:'/service/api/nmzx/teacher_open', name:"教师个人信息 公开课记录"},
    teacher_jyhd:{type:"post", url:'/service/api/nmzx/teacher_jyhd', name:"教师个人信息 教师教研活动"},
    teacher_kt:{type:"post", url:'/service/api/nmzx/teacher_kt', name:"教师个人信息 课题研究"},
    teacher_lw:{type:"post", url:'/service/api/nmzx/teacher_lw', name:"教师个人信息 论文论著"},
    teacher_hjry:{type:"post", url:'/service/api/nmzx/teacher_hjry', name:"教师个人信息 教师获奖荣誉"},
    teacher_hdlb:{type:"post", url:'/service/api/nmzx/teacher_hdlb', name:"教育培训 活动项目"},
    teacher_hdjb_yxlb:{type:"post", url:'/service/api/nmzx/teacher_hdjb_yxlb', name:"教育培训 活动项目 饼图类别"},
    teacher_leavetrend:{type:"post", url:'/service/api/nmzx/teacher_leavetrend', name:"绩效考核 请假趋势"}
};

export function setDianXinRouter(httpServer) {
    for (let key in ApiConfig) {
        let {url, name, type} = ApiConfig[key];
        
        if (type == "post") {
            httpServer.post(url, asyncHandler( async (req, res) => {
                const UrlStr = `http://61.171.4.98:9090${url}`;
                let result;
                if (key == "token") {
                    let param = req.body;
                    result = await postForm(UrlStr, param, {});
                } else {
                    let param = req.body;
                    result = await post(UrlStr, param, {});
                }
                   
                res.packageRes(result);
    
            } ));
        } 
        else {
            httpServer.get(url, asyncHandler( t));
        }
    }
}

async function t(req, res) {
    let url = '/service/api/nmzx/teacher_info_get';
    const UrlStr = `http://61.171.4.98:9090${url}`;
    let param = req.query;
    let result = await get(UrlStr, param, {});

    res.packageRes(result);
}