/**
 * 上海市学生素质教育优质资源平台
 */

import { planarArrDecollateForIndex, planarArrDeconstruct, planarArrForObjectList } from "../../dataPackage/planaryArrayAnalysis";
import { onceSheetBecomeOfblockData, onceSheetBecomeOfblockDataToUrl } from "../../util/analysisExcel";

function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};

    for (let i = 0; i < blockDataList.length; i++) {
        let {blockData, blockTitle} = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrDecollateForIndex(blockData);
    }

    return result;
}


export function weeklyPlayTableData() {
    let blockDataList = onceSheetBecomeOfblockData('上海市学生素质教育优质资源平台.xlsx', 'Sheet1');

    let keyValueOrTitleList = ['课程来源情况', '课程适用年级段', '课程领域分布', '课程投放平台', '基础数据', '课程播放情况', '课程反馈', '在线公益课程评分', '热门标签']; //适配 饼图 键值以及需要多个Key的
    let barChartList = ['课程类别（艺术）', '平台播放量趋势', '平台播放量趋势（直播）', '平台播放量趋势（回放）', '课程收藏/转发量', '课程类型热度排行（本周）']; //适配 柱状图 折线图
    let stringList = [];
    let decollatePlanarList = ['热门课程排行top10（本周）']; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function curriculumTableData() {
    let blockDataList = onceSheetBecomeOfblockData('上海市学生素质教育优质资源平台.xlsx', 'Sheet2');

    let keyValueOrTitleList = ['课程数据']; //适配 饼图 键值以及需要多个Key的
    let barChartList = []; //适配 柱状图 折线图
    let stringList = [];
    let decollatePlanarList = ['']; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


export function getDataByName(xlsName) {
    let blockDataList = onceSheetBecomeOfblockDataToUrl(`${xlsName}.xlsx`, 'Sheet1', '/就业服务记录');

    let keyValueOrTitleList = ['']; //适配 饼图 键值以及需要多个Key的
    let barChartList = []; //适配 柱状图 折线图
    let stringList = [];
    let decollatePlanarList = []; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}






