/**
 * 上海市学生素质教育优质资源平台
 */

import { curriculumTableData, weeklyPlayTableData } from "../data/table/tableData";
import { keyValuePackage, onceYBarChartPackage, stringListPackage, tablePackage } from "../dataPackage/inFrontOut";
import { getKeyValueOut, getStringOut, getOnceYBarChartOut } from "../dataPackage/out";


export function getData(req, res) {
    let excelData = weeklyPlayTableData();

    let ret:any = {};

    /**左屏 */
    let kclyqkPackageData = keyValuePackage(excelData['课程来源情况'].dataList);
    ret['kclyqk'] = getKeyValueOut('课程来源情况', kclyqkPackageData);

    let kcsynjdPackageData = keyValuePackage(excelData['课程适用年级段'].dataList);
    ret['kcsynjd'] = getKeyValueOut('课程适用年级段', kcsynjdPackageData);
    
    let kclyfbPackageData = keyValuePackage(excelData['课程领域分布'].dataList);
    ret['kclyfb'] = getKeyValueOut('课程领域分布', kclyfbPackageData);

    let kclbysChartPackage = onceYBarChartPackage(excelData['课程类别（艺术）'], '');
    ret['kclbys'] = getOnceYBarChartOut('课程类别（艺术）', kclbysChartPackage);

    let kctfptPackageData = stringListPackage(excelData['课程投放平台'].dataList);
    ret['kctfpt'] = getStringOut('课程投放平台', kctfptPackageData);
    
    let jcsjPackageData = keyValuePackage(excelData['基础数据'].dataList);
    ret['jcsj'] = getKeyValueOut('基础数据', jcsjPackageData);
    
    let kcbfqkPackageData = keyValuePackage(excelData['课程播放情况'].dataList);
    ret['kcbfqk'] = getKeyValueOut('课程播放情况', kcbfqkPackageData);

    let ptbflqsChartPackage = onceYBarChartPackage(excelData['平台播放量趋势'], '');
    ret['ptbflqs'] = getOnceYBarChartOut('平台播放量趋势', ptbflqsChartPackage);
    
    let ptbflqsZBChartPackage = onceYBarChartPackage(excelData['平台播放量趋势（直播）'], '');
    ret['ptbflqsZB'] = getOnceYBarChartOut('平台播放量趋势（直播）', ptbflqsZBChartPackage);

    let ptbflqsHFChartPackage = onceYBarChartPackage(excelData['平台播放量趋势（回放）'], '');
    ret['ptbflqsHF'] = getOnceYBarChartOut('平台播放量趋势（回放）', ptbflqsHFChartPackage);

    let kcsczflChartPackage = onceYBarChartPackage(excelData['课程收藏/转发量'], '');
    ret['kcsczfl'] = getOnceYBarChartOut('课程收藏/转发量', kcsczflChartPackage);
    
    let kclxrdphChartPackage = onceYBarChartPackage(excelData['课程类型热度排行（本周）'], '');
    ret['kclxrdph'] = getOnceYBarChartOut('课程类型热度排行（本周）', kclxrdphChartPackage);

    let rmkcphtop10TableList = tablePackage(excelData['热门课程排行top10（本周）'].headerList[0], excelData['热门课程排行top10（本周）'].bodyList);
    ret['rmkcphtop10'] = {title:'热门课程排行top10（本周）', dataList:rmkcphtop10TableList};
    
    let rmbqPackageData = keyValuePackage(excelData['热门标签'].dataList);
    ret['rmbq'] = getKeyValueOut('热门标签', rmbqPackageData);
    
    let kcfkPackageData = keyValuePackage(excelData['课程反馈'].dataList);
    ret['kcfk'] = getKeyValueOut('课程反馈', kcfkPackageData);
    
    let zxgykcpfPackageData = keyValuePackage(excelData['在线公益课程评分'].dataList);
    ret['zxgykcpf'] = getKeyValueOut('在线公益课程评分', zxgykcpfPackageData);
   
    res.send(ret);
}


/**
 * 下拉
 * @param req 
 * @param res 
 */
export function dropDown(req, res) {
    let excelData = curriculumTableData();

    let ret:any = {};

    let popExcelData = excelData['课程数据'].dataList;
    
    let kcqs = ["全部"];
    let ssly = ["全部"];
    let zybq = [];
    popExcelData.forEach( info => {
        kcqs.push(info.kcqs); //期数
        ssly.push(info.ssly); //所属领域
        zybq.push(info.zybq); //资源标签
    });

    let qs = kcqs.filter((item, index) => kcqs.indexOf(item) === index);
    let type = ssly.filter((item, index) => ssly.indexOf(item) === index);
    let lable = zybq.filter((item, index) => zybq.indexOf(item) === index);

    ret['dropDown'] = {qs, type, lable};

    res.send(ret);
}


/**
 * 课程搜索框
 * @param req 
 * @param res 
 */
export function curriculumPop(req, res) {
    let {name, qs, type, lable} = req.query;

    let excelData = curriculumTableData();

    let ret:any = {};
    
    let popExcelData = excelData['课程数据'].dataList;
    let reg = new RegExp(name);

    let popData = [];

    let popSliceData = [];
    if ((!name && !qs && !type && !lable) || (!name && qs == "全部" && type == "全部" && lable == "全部年级")) {
        popExcelData.sort( (a, b) => {
            return b.bfl - a.bfl;
        });
        popSliceData = popExcelData.slice(0, 10);
    } else {
        popSliceData = popExcelData;
    }


    let kcsj; //课程数据
    let kcsjConf = ["kcdz", "ks", "kcmc", "skls", "ssly", "zybq", "dzl", "bfl", "scs", "yddzfl", "kcqs"];
    let zb; //直播
    let zbConf = ["zb1", "zb2", "zb3", "zb4", "zb5", "zb6", "zb7"];
    let hf; //回放
    let hfConf = ["hf1", "hf2", "hf3", "hf4", "hf5", "hf6", "hf7"];
    popSliceData.forEach( info => {
        let kcqs = info.kcqs; //课程期数
        let kcmc = info.kcmc; //课程关键词
        let ssly = info.ssly; //所属领域
        let zybq = info.zybq; //资源标签
        
        let matches = {
            name:true,
            qs:true,
            type:true,
            lable:true
        };

        if (qs) {
            if (qs != kcqs) matches.qs = false;
            if (qs == "全部" || kcqs == "全部") matches.qs = true;
        }

        if (type) {
            if (type != ssly) matches.type = false;
            if (type == "全部" || ssly == "全部") matches.type = true;
        }

        if (lable) {
            if (lable != zybq) matches.lable = false;
            if (lable == "全部年级" || zybq == "全部年级") matches.lable = true;
        }

        if (name) {
            if (reg.test(kcmc)) {
                matches.name = true;
            } else {
                matches.name = false;
            }
        }

        if (matches.name && matches.qs && matches.type && matches.lable) {
            /**课程数据 */
            kcsj = getConfData(info, kcsjConf)
            /**直播数据 */
            zb = getZB(getConfData(info, zbConf));
            /**回放数据 */
            hf = getHF(getConfData(info, hfConf));
            popData.push({"课程数据":kcsj, "直播":zb, "回放":hf});
        }

    })

    ret['popData'] = {title:'弹窗数据', dataList:popData};
    
    res.send(ret);
}


function getConfData(info, conf) {
    let result = {};

    for (let i = 0; i < conf.length; i++) {
        result[conf[i]] = info[conf[i]];
    }

    return result;
}


function getZB(data) {
    let result = [];
    for (let key in data) {
        switch (key) {
            case 'zb1':
                result.push({ key:"周一", value:data[key] });
            break;
            case 'zb2':
                result.push({ key:"周二", value:data[key] });
            break;
            case 'zb3':
                result.push({ key:"周三", value:data[key] });
            break;
            case 'zb4':
                result.push({ key:"周四", value:data[key] });
            break;
            case 'zb5':
                result.push({ key:"周五", value:data[key] });
            break;
            case 'zb6':
                result.push({ key:"周六", value:data[key] });
            break;
            case 'zb7':
                result.push({ key:"周日", value:data[key] });
            break;
        }
    }

    return result;
}


function getHF(data) {
    let result = [];
    for (let key in data) {
        switch (key) {
            case 'hf1':
                result.push({ key:"周一", value:data[key] });
            break;
            case 'hf2':
                result.push({ key:"周二", value:data[key] });
            break;
            case 'hf3':
                result.push({ key:"周三", value:data[key] });
            break;
            case 'hf4':
                result.push({ key:"周四", value:data[key] });
            break;
            case 'hf5':
                result.push({ key:"周五", value:data[key] });
            break;
            case 'hf6':
                result.push({ key:"周六", value:data[key] });
            break;
            case 'hf7':
                result.push({ key:"周日", value:data[key] });
            break;
        }
    }

    return result;
}








