
let fs = require('fs');
let path = require('path');


//对象判空
export function objectKeyIsNull(obj, ...keyNames) {
    let isNull = false;
    for (let i = 0; i < keyNames.length; i++) {
        let keyStr = keyNames[i];
        let moreKeyList = keyStr.split(".");
        let lastObj;
        for (let j = 0; j < moreKeyList.length; j++) {
            lastObj = obj[moreKeyList[j]];
            if (!lastObj) {
                isNull = true;
                break;
            }
        }
        if (isNull) break;
    }
    return isNull;
}


/**
 * 随机服务次数 1-5
 * @param min 
 * @param max 
 * @returns 
 */
export function getRandomInt(min, max) {  
    min = Math.ceil(min);  
    max = Math.floor(max);  
    return Math.floor(Math.random() * (max - min + 1)) + min;  
}


/**
 * 获取原有的数据json
 * @param jsonName json文件名称
 * @returns 
 */
export function getJsonData(jsonName) {
    let filename = path.join(__dirname.substring(0,__dirname.indexOf("out")), jsonName);

    let jsonObject = fs.readFileSync(filename, 'utf-8');

    let baseData = JSON.parse(jsonObject);
    
    console.log(baseData);
    return baseData;
}


/**
 * 更新json数据
 * @param jsonName json文件名称
 */
 export function changeJsonData(jsonName, data) {
    let jsonData = JSON.stringify(data, null, 2);
    let filename = path.join(__dirname.substring(0,__dirname.indexOf("out")), jsonName);

    fs.writeFileSync(filename, jsonData);
    console.log('文件写入成功');
}


