/**
 * 总路由入口
 */

import * as asyncHandler from 'express-async-handler';
import * as userBiz from '../biz/user';
import * as playBiz from '../biz/play';
import * as clueBiz from '../biz/clue';
import * as swotBiz from '../biz/swot';
import * as roiBiz from '../biz/roi';
import * as jinheBiz from '../biz/jinhe';
import { eccReqParamater } from '../tools/eccParam';


export function setRouter(httpServer){
    httpServer.post('/login', asyncHandler(login));
    httpServer.post('/updatename', asyncHandler(updateName));
    httpServer.post('/register', asyncHandler(register));
    httpServer.post('/basedata', asyncHandler(getBaseData));
    httpServer.post('/personal', asyncHandler(getCount));

    httpServer.post('/play', asyncHandler(getPlay));
    httpServer.post('/pubhire', asyncHandler(pubHire));
    httpServer.post('/submithire', asyncHandler(submitHire));
    httpServer.post('/displayhire', asyncHandler(displayHire));
    httpServer.post('/rawmaterial', asyncHandler(rawMaterial));
    httpServer.post('/submitrawmaterial', asyncHandler(submitRawMaterial));
    httpServer.post('/displayrawmaterial', asyncHandler(displayRawMaterial));
    httpServer.post('/gzf', asyncHandler(getGzf));
    httpServer.post('/introducegzf', asyncHandler(getIntroduceGzf));
    httpServer.post('/firstpubhire', asyncHandler(firstPubHire));
    httpServer.post('/npc', asyncHandler(getNPC));
    
    httpServer.post('/clue', asyncHandler(getClue));
    httpServer.post('/checkclue', asyncHandler(checkClue));
    httpServer.post('/againanswer', asyncHandler(againAnswer));
    httpServer.post('/againstart', asyncHandler(againStart));
    httpServer.post('/delclue', asyncHandler(delClue));
    httpServer.post('/choiceclue', asyncHandler(getChoiceClue));
    httpServer.post('/submitclue', asyncHandler(submitClue));
    httpServer.post('/checkswot', asyncHandler(checkSWOT));
    httpServer.post('/checkroi', asyncHandler(checkROI));
    httpServer.post('/checkjinhe', asyncHandler(checkJinhe));

    httpServer.post('/isenabled', asyncHandler(isEnabled));
}


/**
 * 登录
 * @param req 
 * @param res 
 */
function login(req, res) {
    let reqConf = {loginId:'String', pwd:'String'};
    let {loginId, pwd} = eccReqParamater(reqConf, req.body);

    let result = userBiz.login(loginId, pwd);
    res.success(result);
}


/**
 * 修改昵称
 */
function updateName(req, res) {
    let userId = req.headers.userid;
    let {name} = req.body;

    let result = userBiz.updateName(userId, name);
    res.success(result);
}


/**
 * 注册
 * @param req 
 * @param res 
 */
function register(req, res) {
    let reqConf = {loginId:'String', pwd:'String'};
    let {loginId, pwd} = eccReqParamater(reqConf, req.body);

    let result = userBiz.register(loginId, pwd);
    res.success(result);
}


/**基础数据 */
function getBaseData(req, res) {
    let userId = req.headers.userid;
    let result = userBiz.getBaseData(userId);
    res.success(result);
}


/**统计获得线索数 */
function getCount(req, res) {
    let userId = req.headers.userid;
    let result = userBiz.getCount(userId);
    res.success(result);
}


/**
 * 剧情
 * @param req 
 * @param res 
 */
function getPlay(req, res) {
    let userId = req.headers.userid;
    // 商行、SO11、对话Id(后置剧情id)
    let {type, playId, dhId} = req.body;
    let result;
    // if (type == "酒馆") {
    //     result = playBiz.getJGPlayData(userId, type, playId, dhId);
    // } else {
        
    // }
    result = playBiz.getPlayData(userId, type, playId, dhId);
    res.success(result);
}


/**
 * 雇佣工人表格
 * @param req 
 * @param res 
 */
function pubHire(req, res) {
    // 剧情type
    let {playType} = req.body;

    let result = playBiz.pubHire(playType);
    res.success(result);
}


/**
 * 提交雇佣工人
 * @param req 
 * @param res 
 */
function submitHire(req, res) {
    let userId = req.headers.userid;
    // 剧情type
    let {playType, xsId} = req.body;

    let result = playBiz.submitHire(userId, playType, xsId);
    res.success(result);
}


/**
 * 回显雇佣工人
 * @param req 
 * @param res 
 */
function displayHire(req, res) {
    let userId = req.headers.userid;

    let result = playBiz.displayHire(userId);
    res.success(result);
}


/**
 * 原材料表格
 * @param req 
 * @param res 
 */
 function rawMaterial(req, res) {
    // 颜料、瓷器
    let {type} = req.body;

    let result = playBiz.rawMaterial(type);
    res.success(result);
}


/**
 * 提交原材料
 * @param req 
 * @param res 
 */
function submitRawMaterial(req, res) {
    let userId = req.headers.userid;
    let {type, xsId} = req.body;

    let result = playBiz.submitRawMaterial(userId, type, xsId);
    res.success(result);
}


/**
 * 回显原材料
 * @param req 
 * @param res 
 */
function displayRawMaterial(req, res) {
    let userId = req.headers.userid;

    let result = playBiz.displayRawMaterial(userId);
    res.success(result);
}


/**
 * 广州府是否第一次阅读
 * @param req 
 * @param res 
 */
function getGzf(req, res) {
    let userId = req.headers.userid;

    let result = playBiz.getGzf(userId);
    res.success(result);
}


/**
 * 广州府介绍
 * @param req 
 * @param res 
 */
function getIntroduceGzf(req, res) {
    let userId = req.headers.userid;

    let result = playBiz.getIntroduceGzf(userId);
    res.success(result);
}


/**
 * 是否能进入酒馆剧情
 * @param req 
 * @param res 
 */
 function firstPubHire(req, res) {
    let userId = req.headers.userid;

    let result = playBiz.firstPubHire(userId);
    res.success(result);
}


/**
 * NPC
 * @param req 
 * @param res 
 */
function getNPC(req, res) {
    let {type} = req.body;

    let result = playBiz.getNPCData(type);
    res.success(result);
}


/**
 * 是否开启线索
 * @param req 
 * @param res 
 */
 function isEnabled(req, res) {
    let userId = req.headers.userid;

    let result = clueBiz.isEnabled(userId);
    res.success(result);
}


/**
 * 线索
 * 有参数返回对应线索类型数据，没有参数返回全部线索数据
 * @param req 
 * @param res 
 */
function getClue(req, res) {
    let userId = req.headers.userid;
    let {clueType} = req.body;

    let result;
    if(clueType) result = clueBiz.getClue(userId, clueType);
    else result = clueBiz.getClue(userId);

    res.success(result);
}


/**取消选中线索 */
function delClue(req, res) {
    let userId = req.headers.userid;
    let {clueType, xxType, xsid} = req.body;

    let result = clueBiz.delClue(userId, clueType, xxType, xsid);
    res.success(result);
}


/**
 * 提交线索
 * @param req 
 * @param res 
 */
function checkClue(req, res) {
    let userId = req.headers.userid;

    let result = clueBiz.checkClue(userId);
    res.success(result);
}


/**
 * 重新答题
 * @param req 
 * @param res 
 */
 function againAnswer(req, res) {
    let userId = req.headers.userid;

    let result = clueBiz.againAnswer(userId);
    res.success(result);
}


/**
 * 重新开始
 * @param req 
 * @param res 
 */
 function againStart(req, res) {
    let userId = req.headers.userid;

    let result = clueBiz.againStart(userId);
    res.success(result);
}


/**
 * 回显
 * @param req 
 * @param res 
 */
function getChoiceClue(req, res) {
    let userId = req.headers.userid;
    let {clueType} = req.body;

    let result = clueBiz.getChoiceClue(userId, clueType);
    res.success(result);
}


/**
 * 线索选择弹窗确认按钮
 * @param req 
 * @param res 
 */
function submitClue(req, res) {
    let userId = req.headers.userid;
    let {clueType, subdivide, xs} = req.body;

    let result;
    if (clueType == "SWOT") {
        result = swotBiz.submitSWOTClue(userId, subdivide, xs);
    } else if (clueType == "ROI") {
        result = roiBiz.submitROIClue(userId, subdivide, xs);
    } else if (clueType == "竞合") {
        result = jinheBiz.submitJinheClue(userId, subdivide, xs);
    }
    res.success(result);
}


/**
 * 计算SWOT
 * @param req 
 * @param res 
 */
function checkSWOT(req, res) {
    let userId = req.headers.userid;

    let result = swotBiz.checkSWOT(userId);
    res.success(result);
}


/**
 * 计算ROI
 * @param req 
 * @param res 
 */
function checkROI(req, res) {
    let userId = req.headers.userid;

    let result = roiBiz.checkROI(userId);
    res.success(result);
}


/**
 * 计算竞合
 * @param req 
 * @param res 
 */
function checkJinhe(req, res) {
    let userId = req.headers.userid;

    let result = jinheBiz.checkJinhe(userId);
    res.success(result);
}










