import { BizError } from "../util/bizError";
import pyfl from 'pyfl';
//disintegrate 分解二维数据源数据


/**
 * planarArrForObjectList  解析二维数组
 * @param planarArr 二维数组 例子:[[title1, title2, title3, title4],[value1, value2, value3, value4],[value5, value6, value7, value8]]
 * @param titleIndex  标题集合所在第一层数组的下标 
 * @param titleList 自定义标题列表 不传则会取每个title的中文首字母作为key
 * @returns {"dataList":[{title1:value1, title2:value2, title3:value3, title4:value4}, {title1:value5, title2:value6, title3:value7, title4:value8}], titleList:[]}
 */
export function planarArrForObjectList(planarArr, titleIndex = 0, titleList = []) {
    let dataTitleList = [];
    let dataMaxLength = 0;
    for (let i = titleIndex; i< planarArr.length; i++) {
        let subList = planarArr[i];
        if (i == titleIndex) {
            dataTitleList = subList;
            continue;
        }
        dataMaxLength = Math.max(subList.length, dataMaxLength);
    }

    let useTitleList = !titleList.length ? changeChineseTitleIntoEnglish(dataTitleList) : titleList;
    if (dataMaxLength == 2 && !titleList.length) useTitleList = ["key", "value"];
    
    if (dataTitleList.length < dataMaxLength ) throw new BizError(`解析时数据异常 数据长度：${dataMaxLength} 大于 标题长度${dataTitleList}`);
    if (titleList.length && titleList.length < dataMaxLength) throw new BizError(`解析时数据异常 传入标题长度${titleList.length} 数据最大长度${dataMaxLength}`);

    let dataList = [];
    for (let i = (titleIndex + 1); i< planarArr.length; i++) {
        let subList = planarArr[i];
        let addInfo:any = {};
        subList.forEach((item, index) => {
            let key = useTitleList[index];
            let value = item;
            addInfo[key] = value;
        });
        dataList.push(addInfo);
    }

    return {dataList, titleList:useTitleList };
}

function changeChineseTitleIntoEnglish(titles) {
    let result = [];
    titles.forEach(chineseStr => {
        result.push(pyfl(chineseStr).toLowerCase());
    });
    return result;
}

/**
 * planarArrDeconstruct 解构二维数组 
 * 第一列是名称 
 * @param planarArr 二维数组 例：[[name, 1月, 2月, 3月],[数据1, 1月数据, 2月数据,3月数据 ],[数据2, 1月数据, 2月数据,3月数据]]
 * @param titleIndex 标题集合所在第一层数组的下标
 * @returns [{"name":"", data:[{key:"1月", value:"1月数据"}, {key:"2月", value:"2月数据"} ]}];
 */
export function planarArrDeconstruct(planarArr, titleIndex = 0) {
    let dataInfo = []
    let titleList = [];
    for (let i = titleIndex; i < planarArr.length; i++) {
        let subList = planarArr[i];
        if (titleIndex == i){
            titleList = subList;
        } else {
            let thisDataName = "";
            let thisDataList = [];
            subList.forEach((item, index) => {
                if (!index) {
                    thisDataName = item;
                    return;
                }
                let key = titleList[index];
                thisDataList.push({key, value:item});
            });
            dataInfo.push({name:thisDataName, data:thisDataList});
        }
    }

    return dataInfo;
}

/**
 * planarArrDecollateForIndex 拆解二维数组
 * @param planarArr 二维数组
 * @param decollateIndex 拆解开始的下标
 * @returns {headerList:decollateIndex下标之前的集合(包括decollateIndex), bodyList:decollateIndex下标之后的集合(不包括decollateIndex)}
 */
export function planarArrDecollateForIndex(planarArr, decollateIndex = 0) {
    let headerList = planarArr.slice(decollateIndex, decollateIndex + 1);
    let bodyList = planarArr.slice(decollateIndex + 1, planarArr.length);
    return {headerList, bodyList};    
}


