/**
 * 登录
 * 用户.json 登录用户账号信息
 */

import { ERRORENUM } from "../config/errorEnum";
import { xiansuoTableData } from "../data/table/tableData";
import { successErrorResult, successResult } from "../tools/systemTools";
import { BizError } from "../util/bizError";
import { changeJsonData, getJsonData } from "../util/tools";
import { gameLoop, initAllClue } from "./task";
let fs = require('fs');
let path = require('path');

/**
 * 登录
 * @param loginId 账号
 * @param pwd 密码
 */
export function login(loginId, pwd) {
    let userData = getJsonData("json/用户.json");

    let dataInfo = {};
    /**判断是否有对应账号 */
    let hasUser = userData.some(item => item.loginId === loginId);
    if (!hasUser) throw new BizError(ERRORENUM.账号不存在);
    let firstLogin = false;
    userData.forEach( info => {
        initAllClue(info.userId);

        if (info.loginId == loginId) {
            if (info.pwd != pwd) throw new BizError(ERRORENUM.账号或密码错误);
            if (!info.name) firstLogin = true;
            dataInfo = {userId:info.userId, loginId:info.loginId, firstLogin};
            gameLoop(info.userId);
        }

        // dataInfo["firstlogin"] = initAllClue(info.userId);
    })
    
    return dataInfo;
}


/**
 * 注册
 * @param loginId 账号
 * @param pwd 密码
 */
export function register(loginId, pwd) {
    let userData = getJsonData("json/用户.json");

    const NowMs = new Date().valueOf();

    userData.push(
        {
            userId:`${NowMs}`,
            loginId,
            pwd
        }
    );

    changeJsonData("json/用户.json", userData);
    
    let dirPath = path.join(__dirname.substring(0,__dirname.indexOf("out")), `json/${NowMs}`);
    try {
        fs.mkdirSync(dirPath, { recursive: true });
        console.log(`文件夹${dirPath}已成功创建`);
    } catch (err) {
        console.error(`文件夹${dirPath}创建失败${err.message}`);
    }

    return successResult();
}


/**
 * 基础数据【当前天数、银两数】
 * @returns 
 */
 export function getBaseData(userId) {
    let baseData = getJsonData("json/基础数据.json");
    let basicsData = {
        day:0,
        tael:500
    }
    basicsData.day = baseData[userId]["天数"] || 0;
    // basicsData.tael = baseData[userId]["结算"] || 0; //todo第一幕不计算金额，直接使用500金

    return basicsData;
}


/**
 * 统计线索数量
 * @param clueType 
 * @returns 
 */
export function getCount(userId) {
    let excelData = xiansuoTableData();
    let clueExcelData = excelData["线索表"].dataList;
    
    let jsonData = getJsonData("json/全部线索.json");
    let clueData = jsonData[userId];

    let personalData = {
        clue:"",
        tael:500,
        hire:0
    };

    let allClue = clueExcelData.length;
    let clue = 0;
    // 线索数
    for (let key in clueData) {
        clue += clueData[key].length;
        // clueData[key].forEach( info => {
        //     if (info.isChoice) clue++
        // })
    }
    personalData.clue = `${allClue}/${clue}`; //总线索数（线索配置表里的所有线索）/当前解锁的线索数
    
    // 银两数 todo 第一幕不计算银两数，默认展示500金
    // let baseData = getJsonData("json/基础数据.json");
    // personalData.tael = baseData[userId]["结算"];

    // 雇佣人数
    let hireData = getJsonData("json/雇佣选择.json");
    if (hireData[userId]) {
        if (Object.keys(hireData[userId]).length != 0) {
            if (!hireData[userId]["人工"]) hireData[userId]["人工"] = {}
            if (Object.keys(hireData[userId]["人工"]).length != 0) {
                personalData.hire = Object.keys(hireData[userId]["人工"]).length;
            }
        }
    }
    
    return personalData;
}


/**
 * 昵称禁词配置
 * 
 */
const chineseNicknameForbiddenWords = [
    '傻逼',       // 低俗侮辱性词汇
    '贱人',       // 低俗侮辱性词汇
    '他妈的',     // 低俗侮辱性词汇，含有辱骂家属成分
    '日',         // 低俗词汇，可能涉及性行为暗示
    '草',         // 低俗词汇，可能涉及性行为暗示
    '屁',         // 低俗词汇，表示不屑或侮辱
    '操',         // 低俗词汇，可能涉及性行为或侮辱
    '狗屎',       // 低俗词汇，表示贬低或侮辱
    '王八蛋',     // 低俗侮辱性词汇，用于骂人
    '尼玛',       // 低俗侮辱性词汇，谐音“你妈”
    '黑鬼',       // 种族歧视词汇，用于贬低黑人
    '鬼子',       // 含有对特定历史背景下外国人的贬低和侮辱意味
    '太监',       // 性别歧视词汇，用于贬低男性
    '婊子',       // 性别歧视词汇，用于贬低女性
    '法轮功',     // 政治敏感词汇，涉及邪教组织
    '共产党',     // 政治敏感词汇，在不当语境下使用可能被视为不尊重或挑衅
    '反动',       // 政治敏感词汇，表示反对或颠覆政权
    '暴恐',       // 涉及暴力恐怖活动的词汇
    '色情',       // 涉及色情内容的词汇
    '赌博',       // 涉及赌博活动的词汇
    '吸毒',       // 涉及毒品或吸毒行为的词汇
    // 可以根据实际需求继续添加其他中文禁词
];

/**
 * 字符类型限制：只能包含字母、数字、下划线和中文字符
 * 中文字符的Unicode范围是\u4e00-\u9fa5
 */
const nicknameRegex = /^[a-zA-Z0-9_\u4e00-\u9fa5]+$/;


/**
 * 修改昵称
 * @param userId 
 */
 export function updateName(userId, name) {
    let userData = getJsonData("json/用户.json");
    let isOk = true;
    let result;
    userData.forEach( info => {
        if (info.userId == userId) {
            for (let i = 0; i < chineseNicknameForbiddenWords.length; i++) {
                let word = chineseNicknameForbiddenWords[i];
                if (name.includes(word)) {
                    isOk = false;
                    result = successErrorResult("昵称包含敏感词汇，修改昵称失败");
                }
                if (!nicknameRegex.test(name)) {
                    isOk = false;
                    result = successErrorResult("昵称只能包含字母、数字、下划线和中文字符。");
                }
            }
            info["name"] = name;
        }
    })

    if(isOk) {
        changeJsonData("json/用户.json", userData);
        result = successResult();
    }

    return result;
}









