/**
 * 初始化全部线索
 */

import { HARITYPE, NOWCLUE } from "../config/enum";
import { guyongTableData, xiansuoTableData } from "../data/table/tableData";
import { changeJsonData, getJsonData } from "../util/tools";


/**
 * 登录账号的时候判断是否有初始化全部线索，没有的话写入全部线索json
 * 基础数据没有的话也写入
 *  todo线索改为剧情走过才添加
 */
export function initAllClue(userId) {
    let excelData = xiansuoTableData();
    let clueExcelData = excelData["线索表"].dataList;

    let userJsonData = getJsonData("json/用户.json");
    let allClueJsonData = getJsonData("json/全部线索.json");
    let baseJsonData = getJsonData("json/基础数据.json");
    let submitJsonData = getJsonData("json/提交分数.json");

    let writeClueAll = allClueJsonData;
    let writeBaseAll = baseJsonData;
    let submitClue = submitJsonData;

    /**如果登录的账号没有全部线索数据，则写入json
     * 弃用，改为走过相关剧情添加对应线索
     */
    // if (!allClueJsonData[userId] || Object.keys(allClueJsonData[userId]).length === 0) {
    //     writeClueAll[userId] = {};
    //     clueExcelData.forEach( info => {
    //         let {xsid, xsnr, xslx, xslxxf, sfbx} = info;
    //         if (!writeClueAll[userId][xslx]) writeClueAll[userId][xslx] = [];
    //         writeClueAll[userId][xslx].push({xsid, xsnr, isChoice:false, sfbx});
    //     })
    //     //写入json
    //     changeJsonData("json/全部线索.json", writeClueAll);
    // }

    /**如果登录的账号没有基础数据，则写入json */
    if (!baseJsonData[userId] || Object.keys(baseJsonData[userId]).length === 0) {
        writeBaseAll[userId] = {
            "初始资金": 500,
            "天数":0,
            "结算":500,
            "广州府介绍": true, //广州府第一次介绍：true
            // "酒馆雇佣": false, //酒馆已选择雇佣工人：true
            "酒馆剧情": HARITYPE.未开始, //酒馆剧情：默认未开始，已开始需要SWOT确认
            "当前线索确认": NOWCLUE.未开始,
            "商行选择":false,
            "SWOT": false,
            "ROI": false,
            "竞合": false
        }
        //写入json
        changeJsonData("json/基础数据.json", writeBaseAll);
    }
    /**如果登录的账号没有初始化分数数据，则写入json */
    if (!submitJsonData[userId] || Object.keys(submitJsonData[userId]).length === 0) {
        submitClue[userId] = {
            SWOT:0,
            ROI:0,
            竞合:0
        };
        //写入json
        changeJsonData("json/提交分数.json", submitClue);
    }
}


/**
 * 初始化制作瓷器成本数据
 */
export function initCiqi() {
    let excelData = guyongTableData();
    let 雇佣Data = excelData['雇佣表'].dataList;
    let 运输Data = excelData['运输'].dataList;
    let 原材料Data = excelData['原材料'].dataList;
    
    let 人员成本 = {};
    雇佣Data.forEach( info => {
        let {lx, xsid, nlsjz, xqz, gz} = info //线索id，能力值，心情值，工资
        let ycl = 0; //月产量 = 能力值*心情值*30
        if (lx == "工人") ycl = nlsjz*xqz*30;
        if (lx == "画师") ycl = nlsjz*xqz*20;
        if (lx == "掌柜") ycl = nlsjz*xqz*10;
         
        let fjcb = Math.round((gz/ycl)*100)/100; //附加成本 = 工资/月产量
        人员成本[xsid] = {ycl, gz, fjcb};
    })

    let 运输成本 = {};
    运输Data.forEach( info => {
        let {xsid, sjmc, jg, myysl} = info; //线索id，运输类型（车路、水路），价格，每月运输量（速度）
        let xjb = Math.round((jg/myysl)*100)/100; //性价比 = 价格/速度
        运输成本[xsid] = {sjmc, xjb};
    })

    let 原材料 = {};
    原材料Data.forEach( info => {
        let {xsid, sjmc, jg} = info;
        原材料[sjmc] = {xsid, jg:parseInt(jg)};
    })

    let 瓷器 = {
        "定制精美瓷器": {
            "瓷器":原材料["定制瓷器"].xsid,
            "颜料":原材料["优质颜料"].xsid,
            "单价":300,
            "固定成本":原材料["定制瓷器"].jg + 原材料["优质颜料"].jg,
        },
        "定制普通瓷器": {
            "瓷器":原材料["定制瓷器"].xsid,
            "颜料":原材料["普通颜料"].xsid,
            "单价":270,
            "固定成本":原材料["定制瓷器"].jg + 原材料["普通颜料"].jg,
        },
        "通用精美瓷器": {
            "瓷器":原材料["通用瓷器"].xsid,
            "颜料":原材料["优质颜料"].xsid,
            "单价":170,
            "固定成本":原材料["通用瓷器"].jg + 原材料["优质颜料"].jg,
        },
        "通用普通瓷器": {
            "瓷器":原材料["通用瓷器"].xsid,
            "颜料":原材料["普通颜料"].xsid,
            "单价":150,
            "固定成本":原材料["通用瓷器"].jg + 原材料["普通颜料"].jg,
        }
    };

    let 成本 = {瓷器, 人员成本, 运输成本}

    changeJsonData("json/瓷器制造.json", 成本);
}


/**
 * 游戏天数
 * 登录开始计算 30分钟加一天
 * @param userId 
 */
export function gameLoop(userId) {
    let baseJsonData = getJsonData("json/基础数据.json");
    
    // let baseData = baseJsonData[userId];
    baseJsonData[userId]["天数"]++;
    
    //60000毫秒 = 1分钟，设定30分钟游戏内天数+1
    setTimeout(gameLoop, 60000*30, userId);
    
    changeJsonData("json/基础数据.json", baseJsonData);
}









