/**
 * SWOT线索
 * 50：SWOT线索总分数 (该公式计算错误：N/M*（1/4）*50)
 * 分数计算规则：N/M*50
 * M：线索总数
 * N：选对线索数
 * 1/4：细分线索类型数量(S、W、O、T)
 */

import { HARITYPE, NOWCLUE } from "../config/enum";
import { successResult } from "../tools/systemTools";
import { changeJsonData, getJsonData } from "../util/tools";


/**
 * SWOT线索确认
 * @param subdivide  细分线索类型【S、W、O、T】
 * @param xs [{xsid:"", xsnr:""}, ...]
 */
 export function submitSWOTClue(userId, subdivide, xs) {
    let jsonData = getJsonData("json/SWOT.json");

    /**处理确认选择的线索 */
    let SWOTClueData = jsonData;
    //没有对应用户数据先添加一个基础格式，有的话直接push
    if (!SWOTClueData[userId] || Object.keys(SWOTClueData[userId]).length === 0) {
        SWOTClueData[userId] = {
            "isSubmit": false,
            "S": [],
            "W": [],
            "O": [],
            "T": []
        };
    }

    //isSubmit:false【未提交】、true【提交】
    /**当前线索类型未提交时，可以修改添加线索 */
    if (!SWOTClueData[userId]["isSubmit"]) {
        for (let i = 0; i < xs.length; i++) {
            // let xsInfo = xs[i];
            SWOTClueData[userId][subdivide].push(xs[i]);
        }
        changeJsonData("json/SWOT.json", SWOTClueData);
        console.log("添加SWOT线索成功");
    } else {
        console.log("线索已提交，无法重复提交");
    }
    
    /**修改全部线索.json的对应线索为已选择 isChoice：true */
    let allClueJson = getJsonData("json/全部线索.json");
    let allClueData = allClueJson;

    xs.forEach( info => {
        let {xsid, xsnr} = info;
        for(let key in allClueData[userId]) {
            allClueData[userId][key].forEach( thisClue => {
                if(xsid == thisClue.xsid) thisClue.isChoice = true; 
            })
        }
    });
    
    changeJsonData("json/全部线索.json", allClueData);

    let baseJsonData = getJsonData("json/基础数据.json");
    baseJsonData[userId]["当前线索确认"] = NOWCLUE.SWOT;
    if (baseJsonData[userId]["酒馆剧情"] < HARITYPE.已开始) baseJsonData[userId]["酒馆剧情"] = HARITYPE.已开始;
    changeJsonData("json/基础数据.json", baseJsonData);

    return successResult();
}


/**
 * 计算选择正确的SWOT线索
 * @param userId
 */
export function checkSWOT(userId) {
    /**获取细分线索 */
    let xfclueJson = getJsonData("json/细分线索.json");
    let clueJson = getJsonData("json/SWOT.json")[userId];

    let sumClue = 0; //线索总数
    let rightClue = 0; //选对线索数

    let xfclueSWOTJson = xfclueJson["SWOT"];
    let conf = ["S", "W", "O", "T"];
    
    for (let i = 0; i < conf.length; i++) {
        let allxf = xfclueSWOTJson[conf[i]] || []; //所有细分的线索
        sumClue += allxf.length;
        let rightXf = clueJson[conf[i]] || []; //选中提交的细分线索

        for (let xf = 0; xf < allxf.length; xf++) {
            rightXf.forEach( info => {
                if (allxf[xf] == info.xsid) rightClue++; //计算当前选对线索数
            })
        }
    }
    /**计算分数 */
    let score = 0;
    // score = rightClue/sumClue*(1/4)*50;
    score = (rightClue/sumClue)*50;
    let submitJsonData = getJsonData("json/提交分数.json");
    let submitScore = submitJsonData;
    submitScore[userId]["SWOT"] = score;
    changeJsonData("json/提交分数.json", submitScore);

    return successResult();
}





