/**
 * ROI线索
 * 30：ROI线索总分数
 * 满分：净利润超过30
 * 20分：净利润大于25，小于30
 * 10分：净利润大于20，小于25
 * 0分：净利润小于20
 */

import { NOWCLUE } from "../config/enum";
import { guyongTableData } from "../data/table/tableData";
import { successResult } from "../tools/systemTools";
import { changeJsonData, getJsonData } from "../util/tools";


/**
 * ROI线索确认
 * @param subdivide 细分线索类型【R、O、I】
 * @param xs [{xsid:"", xsnr:""}, ...]
 */
 export function submitROIClue(userId, subdivide, xs) {
    let jsonData = getJsonData("json/ROI.json");
    let baseClueJson = getJsonData("json/基础数据.json");

    /**处理确认选择的线索 */
    let ROIClueData = jsonData;
    //没有对应用户数据先添加一个基础格式，有的话直接push
    if (!ROIClueData[userId] || Object.keys(ROIClueData[userId]).length === 0) {
        ROIClueData[userId] = {
            "isSubmit": false,
            "R": [],
            "I": []
        };
    }

    //isSubmit:false【未提交】、true【提交】
    /**当前线索类型未提交时，可以修改添加线索 */
    if (!ROIClueData[userId]["isSubmit"]) {
        for (let i = 0; i < xs.length; i++) {
            // let xsInfo = xs[i];
            ROIClueData[userId][subdivide].push(xs[i]);
        }
        changeJsonData("json/ROI.json", ROIClueData);
        console.log("添加ROI线索成功");
    } else {
        console.log("线索已提交，无法重复提交");
    }
    
    /**修改全部线索.json的对应线索为已选择 isChoice：true */
    let allClueJson = getJsonData("json/全部线索.json");
    let allClueData = allClueJson;

    xs.forEach( info => {
        let {xsid, xsnr} = info;
        for(let key in allClueData[userId]) {
            allClueData[userId][key].forEach( thisClue => {
                if(xsid == thisClue.xsid) thisClue.isChoice = true; 
            })
        }

        /**如果添加的R线索，马可波罗需要支付瓷器金额 */
        if (subdivide == "R") {
            /**制作瓷器成功，支付定制瓷器金额 */
            let excelData = guyongTableData();
            let ciqiExcel = excelData['制作瓷器'].dataList;
            let ciqiMoney = 0;
            let oldgz = 0;
            ciqiExcel.forEach( info => {
                if (info.xsid == xsid) ciqiMoney = info.sj;
            });
            //加上定制瓷器金额
            baseClueJson[userId]["结算"] = baseClueJson[userId]["结算"] + ciqiMoney * 1000;
        }

    });
    
    changeJsonData("json/全部线索.json", allClueData);

    /**ROI线索选择完成可添加竞合线索 */
    baseClueJson[userId]["竞合"] = true;
    baseClueJson[userId]["当前线索确认"] = NOWCLUE.ROI;
    
    //更新json数据
    changeJsonData("json/基础数据.json", baseClueJson);
    
    return successResult();
}


/**
 * 计算选择正确的ROI线索
 * @param userId 
 */
export function checkROI(userId) {
    let gygrJson = getJsonData("json/雇佣选择.json"); //获取雇佣工人表
    let 雇佣选择 = gygrJson[userId];
    let cqzzJson = getJsonData("json/瓷器制造.json");

    /**
     * 计算工人、画师、掌柜一起的人员成本
     */
    let 人员成本 = cqzzJson["人员成本"];
    let worker = {};
    for (let key in 雇佣选择["人工"]) {
        worker[key] = 人员成本[雇佣选择["人工"][key]].fjcb; //拿到玩家选择工人的附加成本
    }
    let rycb = 0;
    for (let key in worker) {
        rycb += worker[key];
    }

    /**
     * 计算原材料成本
     */
    let 瓷器成本 = cqzzJson["瓷器"];
    let 瓷器利润 = 0;
    let 瓷器单价 = 0;
    for (let cq in 瓷器成本) {
        if(瓷器成本[cq]["瓷器"] == 雇佣选择["原材料"]["瓷器"] && 瓷器成本[cq]["颜料"] == 雇佣选择["原材料"]["颜料"]) {
            let dj = 瓷器成本[cq]["单价"];
            let gdcb = 瓷器成本[cq]["固定成本"];
            瓷器利润 = dj-gdcb;
        }
    }

    /**
     * 计算运输成本
     */
     let 运输成本 = cqzzJson["运输成本"];
    let yscb = 运输成本[雇佣选择["运输"]].xjb;
    
    let 净利润 = (瓷器利润-rycb-yscb)/瓷器单价;

    /**计算分数 */
    let score = 0;
    if (净利润>30) score = 30;
    if (净利润>25 && 净利润<30) score = 20;
    if (净利润>20 && 净利润<25) score = 10;
    if (净利润<20) score = 0;

    let submitJsonData = getJsonData("json/提交分数.json");
    let submitScore = submitJsonData;
    submitScore[userId]["ROI"] = score;
    changeJsonData("json/提交分数.json", submitScore);

    return successResult();
}







