/**
 * 竞合线索
 * 20：竞合线索总分数 (该公式计算错误：N/M*（1/5）*20)
 * 分数计算规则：N/M*20
 * M：线索总数
 * N：选对线索数
 * 1/5：细分线索类型数量(供方、现有竞争、潜在竞争、替代竞争、买方)
 */

import { NOWCLUE } from "../config/enum";
import { successResult } from "../tools/systemTools";
import { changeJsonData, getJsonData } from "../util/tools";


/**
 * 竞合线索确认
 * @param subdivide 细分线索类型【供方、现有竞争、潜在竞争、替代竞争、买方】
 * @param xs [{xsid:"", xsnr:""}, ...]
 */
export function submitJinheClue(userId, subdivide, xs) {
    let jsonData = getJsonData("json/竞合.json");

    /**处理确认选择的线索 */
    let jinheClueData = jsonData;
    //没有对应用户数据先添加一个基础格式，有的话直接push
    if (!jinheClueData[userId] || Object.keys(jinheClueData[userId]).length === 0) {
        jinheClueData[userId] = {
            "isSubmit": false,
            "供方": [],
            "现有竞争": [],
            "潜在竞争": [],
            "替代竞争": [],
            "买方": []
        };
    }

    //isSubmit:false【未提交】、true【提交】
    /**当前线索类型未提交时，可以修改添加线索 */
    if (!jinheClueData[userId]["isSubmit"]) {
        for (let i = 0; i < xs.length; i++) {
            // let xsInfo = xs[i];
            jinheClueData[userId][subdivide].push(xs[i]);
        }
        changeJsonData("json/竞合.json", jinheClueData);
        console.log("添加ROI线索成功");
    } else {
        console.log("线索已提交，无法重复提交");
    }
    
    /**修改全部线索.json的对应线索为已选择 isChoice：true */
    let allClueJson = getJsonData("json/全部线索.json");
    let allClueData = allClueJson;

    xs.forEach( info => {
        let {xsid, xsnr} = info;
        for(let key in allClueData[userId]) {
            allClueData[userId][key].forEach( thisClue => {
                if(xsid == thisClue.xsid) thisClue.isChoice = true; 
            })
        }
    });
    
    changeJsonData("json/全部线索.json", allClueData);

    let baseJsonData = getJsonData("json/基础数据.json");
    baseJsonData[userId]["当前线索确认"] = NOWCLUE.竞合;
    changeJsonData("json/基础数据.json", baseJsonData);
    
    return successResult();
}



/**
 * 计算选择正确的竞合线索
 * @param userId
 */
export function checkJinhe(userId) {
    /**获取细分线索 */
    let xfclueJson = getJsonData("json/细分线索.json");
    let clueJson = getJsonData("json/竞合.json")[userId];

    let sumClue = 0; //线索总数
    let rightClue = 0; //选对线索数

    let xfclueROIJson = xfclueJson["竞合"];
    
    let score = 0;
    
    let conf = ["供方", "现有竞争", "潜在竞争", "替代竞争", "买方"];
    for (let i = 0; i < conf.length; i++) {
        let allxf = xfclueROIJson[conf[i]] || []; //所有细分的线索
        sumClue += allxf.length;
        let rightXf = clueJson[conf[i]] || []; //选中提交的细分线索

        for (let xf = 0; xf < allxf.length; xf++) {
            rightXf.forEach( info => {
                if (allxf[xf] == info.xsid) rightClue++;
            })
        }
    }
    
    /**计算分数 */
    // score = rightClue/sumClue*(1/5)*20;
    score = (rightClue/sumClue)*20;
    let submitJsonData = getJsonData("json/提交分数.json");
    let submitScore = submitJsonData;
    submitScore[userId]["竞合"] = score;
    changeJsonData("json/提交分数.json", submitScore);

    return successResult();
}





