/**
 * 线索
 * S：100、A：100-85、B：85-70、C：70-55、D：55-0
 */

import { HARITYPE, NOWCLUE } from "../config/enum";
import { xiansuoTableData, guyongTableData } from "../data/table/tableData";
import { successResult } from "../tools/systemTools";
import { changeJsonData, getJsonData } from "../util/tools";


/**
 * 是否启用线索
 * @param userId 
 */
export function isEnabled(userId:string) {
    //获取已有json数据
    let baseData = getJsonData("json/基础数据.json")[userId];
    let isEnabled = {
        "SWOT": baseData.SWOT,
        "ROI": baseData.ROI,
        "竞合": baseData.竞合
    };

    return isEnabled;
}


/**
 * 弃用
 * 添加线索 todo线索改为剧情走过才添加
 * @param userId 
 */
export function addClue(userId:string) {
    let excelData = xiansuoTableData();

    let clueExcelData = excelData["线索表"].dataList;

    let writeClueAll = {};
    
    /**添加全部线索 */
    let clueData = {};
    clueExcelData.forEach( info => {
        let {xsid, xsnr, xslx, xslxxf, zs, dhgl, sfbx} = info;
        if (!clueData[xslx]) clueData[xslx] = [];
        clueData[xslx].push({xsid, xsnr});
        if (!writeClueAll[userId]) writeClueAll[userId] = [];
        writeClueAll[userId].push({xsid, xsnr, isChoice:false});
    })

    let allClueJson = getJsonData("json/全部线索.json");
    if(!allClueJson[userId] || allClueJson[userId].length == 0) addAllClue(writeClueAll);
    console.log(`${userId}全部线索添加成功`);
}


/**
 * 添加细分线索 todo线索改为剧情走过才添加
 */
export function xfxxClue() {
    let excelData = xiansuoTableData();

    let clueExcelData = excelData["线索表"].dataList;
    let swotClue = { "S":[], "W":[], "O":[], "T":[] };
    let roiClue = { "R":[], "I":[] };
    let jinheClue = { "供方":[], "现有竞争":[], "潜在竞争":[], "替代竞争":[], "买方":[] }
    clueExcelData.forEach( info => {
        let xslxxf = info.xslxxf;
        for (let key in swotClue) {
           if (xslxxf == key) swotClue[key].push(info.xsid);
        }

        for (let key in roiClue) {
            if (xslxxf == key) roiClue[key].push(info.xsid);
        }
        
        for (let key in jinheClue) {
            if (xslxxf == key) jinheClue[key].push(info.xsid);
        }

    });

    let xfxxClueJson = {
        "SWOT":swotClue,
        "ROI":roiClue,
        "竞合":jinheClue
    };

    changeJsonData("json/细分线索.json", xfxxClueJson);
    // let xfClueJson = getJsonData("json/细分线索.json");
    // if(!xfClueJson || Object.keys(xfxxClueJson).length === 0) changeJsonData("json/细分线索.json", xfxxClueJson);
    console.log(`细分线索添加成功`);
}



/**
 * 提交线索
 * @param clueType  线索类型【SWOT、ROI、竞合】
 */
 export function submitClue(userId, clueType) {
    let jsonData = getJsonData(`json/${clueType}.json`);
    let baseData = jsonData;

    //isSubmit:false【未提交】、true【提交】
    baseData[userId]["isSubmit"] = true;
    changeJsonData("json/已提交线索.json", baseData);
    console.log("已提交线索");

    /**清空原有剧情和线索 */
    // restart(userId);

    return successResult();
}


/**
 * 弃用
 * 添加全部线索
 * @param data
 */
export function addAllClue(data) {
    let jsonData = getJsonData("json/全部线索.json");
    let baseData = jsonData;

    //isChoice:false【未选择】、true【已选择】
    if (Object.keys(baseData).length === 0 || !baseData) {
        changeJsonData("json/全部线索.json", data);
        console.log("已添加全部线索");
    }

}


/**
 * 线索
 * 有参数返回对应线索类型数据，没有参数返回已走过剧情的全部线索数据
 * @param clueType 线索类型
 * @returns 
 */
export function getClue(userId, clueType?) {
    let excelData = xiansuoTableData();
    let clueExcelData = excelData["线索表"].dataList;

    let clueData = {};
    clueExcelData.forEach( info => {
        let {xsid, xsnr, xslx, sfbx} = info;
        if (!clueData[xslx]) clueData[xslx] = [];
        clueData[xslx].push({xsid, xsnr, sfbx});
    })

    /**如果登录的账号没有全部线索数据，则写入json */
    // let allClueJson = getJsonData("json/全部线索.json");
    // let writeClueAll = allClueJson;
    // if (Object.keys(allClueJson[userId]).length == 0) {
    //     writeClueAll[userId] = {};
    //     clueExcelData.forEach( info => {
    //         let {xsid, xsnr, xslx, xslxxf, sfbx} = info;
    //         if (!writeClueAll[userId][xslx]) writeClueAll[userId][xslx] = [];
    //         writeClueAll[userId][xslx].push({xsid, xsnr, isChoice:false, sfbx});
    //     })
    //     //写入json
    //     changeJsonData("json/全部线索.json", writeClueAll);
    // }
    let clueList = [];
    
    let guyongJson = getJsonData("json/雇佣选择.json");
    let guyongUserJson = guyongJson[userId];
    
    let grData:any = {"工人":[], "画师":[], "掌柜":[], "运输":[], "颜料":[], "瓷器":[], "是":[], "否":[], "制成瓷器":[]};
    /**特化ROI线索列表，返回已选择的工人、画师、掌柜 */
    if (clueType == "ROI") {
        //根据原材料选择出制作的是哪个款式的瓷器
        let gyExcelData = guyongTableData();
        let zzcqExcelData = gyExcelData["制作瓷器"].dataList;
    
        let 瓷器材料 = guyongUserJson["原材料"]["瓷器"];
        let 颜料材料 = guyongUserJson["原材料"]["颜料"];
    
        zzcqExcelData.forEach( info => {
            let {xsid, lx, sj, yl, cq} = info;
            if (yl == 颜料材料 && cq == 瓷器材料) {
                guyongUserJson["制成瓷器"] = xsid;
            }
        })
        guyongJson[userId] = guyongUserJson;
        changeJsonData("json/雇佣选择.json", guyongJson);

        let ROI = [];
        clueData[clueType].forEach( info => {
            let {xsid, xsnr, sfbx} = info;
            for (let key in grData) {
                if (key == sfbx) {
                    grData[sfbx].push({xsid, xsnr});
                }
            }
        })

        let ptgr = guyongUserJson["人工"]["工人"] || "";
        let hs = guyongUserJson["人工"]["画师"] || "";
        let zg = guyongUserJson["人工"]["掌柜"] || "";
        let ys = guyongUserJson["运输"] || "";
        let cq = 瓷器材料 || "";
        let yl = 颜料材料 || "";
        let zccq = guyongUserJson["制成瓷器"] || "";

        for (let key in grData) {
            let xsid = guyongUserJson[key];
            grData[key].forEach(info => {
                if(info.xsid == ptgr || info.xsid == hs || info.xsid == zg || info.xsid == ys || info.xsid == cq || info.xsid == yl || info.xsid == zccq) {
                    ROI.push(info);
                }
                if (key == "是" || key == "否") {
                    ROI.push(info);
                }
            })
        }

        clueData["ROI"] = ROI;
    }

    let allClueChange = getJsonData("json/全部线索.json");
    if(clueType) {
        clueData[clueType].forEach( info => {
            // for(let key in allClueChange[userId]) {
                
            // }
            allClueChange[userId][clueType].forEach( thisClue => {
                if(info.xsid == thisClue.xsid) {
                    clueList.push(thisClue);
                }
            })
        })
    } else {
        for(let key in allClueChange[userId]) {
            allClueChange[userId][key].forEach( thisClue => {
                clueList.push(thisClue);
            })
        }
    }

    if(clueList) {
        clueList.sort( (a, b) => {
            if (a.isChoice === true && b.isChoice === false) {
                return 1;
            } else if (a.isChoice === false && b.isChoice === true) {
                return -1;
            }
            return 0;
        });
    }

            
    return clueList;
}


/**
 * 回显细分线索
 * @param clueType  线索类型【SWOT、ROI、竞合】
 */
export function getChoiceClue(userId, clueType) {
    let jsonData = getJsonData(`json/${clueType}.json`);
    let baseData = {};
    if (Object.keys(jsonData).length === 0) baseData = {};
    else baseData = jsonData[userId];

    return baseData;
}


/**
 * 取消选中的线索
 * @param clueType 线索类型【SWOT、ROI、竞合】
 * @param xxType 线索细分类型【S、O、W ...】
 * @param xsid 线索id: C001
 * @returns 
 */
export function delClue(userId, clueType, xxType, xsid) {
    let jsonData = getJsonData(`json/${clueType}.json`);
    let baseData = jsonData;

    let clueData = baseData[userId][xxType];
    /**过滤掉xsid的元素 */
    let clueDelData = clueData.filter(x => ![xsid].includes(x.xsid));
    baseData[userId][xxType] = clueDelData;
    changeJsonData(`json/${clueType}.json`, baseData);
    console.log(baseData);

    let allClueJson = getJsonData("json/全部线索.json");
    // let allClueData = allClueJson;
    for (let key in allClueJson[userId]) {
        allClueJson[userId][key].forEach( thisClue => {
            if(xsid == thisClue.xsid) thisClue.isChoice = false; 
        });
    }
    
    changeJsonData("json/全部线索.json", allClueJson);

    if (xxType == "R") {
        let excelData = guyongTableData();
        let ciqiExcel = excelData['制作瓷器'].dataList;
        let ciqiMoney = 0;
        let baseClueJson = getJsonData("json/基础数据.json");
        ciqiExcel.forEach( info => {
            if (info.xsid == xsid) ciqiMoney = info.sj;
        });
        //加上定制瓷器金额
        let jsje = baseClueJson[userId]["结算"] || 0;
        baseClueJson[userId]["结算"] = jsje - ciqiMoney * 1000;
        changeJsonData("json/基础数据.json", baseClueJson);
    }

    return successResult();
}


/**
 * 提交线索
 * @param userId 
 */
export function checkClue(userId) {
    let jsonData = getJsonData("json/提交分数.json")[userId];

    let swot = jsonData["SWOT"] || 0;
    let roi = jsonData["ROI"] || 0;
    let jinhe = jsonData["竞合"] || 0;

    let score = swot + roi + jinhe;

    let result = {
        rating: "",
        msg: "",
        nextAct: false
    }
    if (score >= 100) {
        result.rating = "S";
        result.msg = "恭喜你本次学习获得评级"
        result.nextAct = true;
    }
    
    if (score > 85 && score < 100) {
        result.rating = "A";
        result.msg = "恭喜你本次学习获得评级"
        result.nextAct = true;
    }

    if (score > 70 && score < 85) {
        result.rating = "B";
        result.msg = "建议重新答题，本次学习获得评级"
        result.nextAct = true;
    }
    
    if (score > 55 && score < 70) {
        result.rating = "C";
        result.msg = "建议重新答题，本次学习获得评级"
        result.nextAct = false;
    }
    
    if (score < 55) {
        result.rating = "D";
        result.msg = "建议重新答题，本次学习获得评级"
        result.nextAct = false;
    }

    return result;
}


/**
 * 重新答题
 * 只需清空已选择线索，剧情不需要重新玩
 * @param userId 
 */
export function againAnswer(userId) {
    //根据原材料选择出制作的是哪个款式的瓷器
    let baseClueJson = getJsonData("json/基础数据.json");
    let guyongJson = getJsonData("json/雇佣选择.json");
    let guyongUserJson = guyongJson[userId];
    let gyExcelData = guyongTableData();
    let zzcqExcelData = gyExcelData["制作瓷器"].dataList;

    let 瓷器材料 = guyongUserJson["原材料"]["瓷器"];
    let 颜料材料 = guyongUserJson["原材料"]["颜料"];

    let ciqiMoney = 0;
    zzcqExcelData.forEach( info => {
        let {xsid, lx, sj, yl, cq} = info;
        if (yl == 颜料材料 && cq == 瓷器材料) {
            zzcqExcelData.forEach( info => {
                if (info.xsid == xsid) ciqiMoney = info.sj;
            });
        }
    })

    //删去结算金额上的定制瓷器金额
    let jsje = baseClueJson[userId]["结算"] || 0;
    baseClueJson[userId]["结算"] = jsje - ciqiMoney * 1000;
    changeJsonData("json/基础数据.json", baseClueJson);

    let againJson = ["SWOT", "ROI", "竞合"];
    for (let i = 0; i < againJson.length; i++) {
        let allJson = getJsonData(`json/${againJson[i]}.json`);
        allJson[userId] = {};
        changeJsonData(`json/${againJson[i]}.json`, allJson);
    }

    /**修改全部线索的已选中 */
    let allClueJson = getJsonData("json/全部线索.json");
    // let allClueData = allClueJson;
    for (let key in allClueJson[userId]) {
        allClueJson[userId][key].forEach( thisClue => {
            thisClue.isChoice = false;
        });
    }
    
    changeJsonData("json/全部线索.json", allClueJson);

    return successResult();
}


/**
 * 重新开始
 * 当前用户数据全部清空
 * @param userId 
 */
export function againStart(userId) {
    let againJson = ["雇佣选择", "全部线索", "提交分数", "细分线索", "SWOT", "ROI", "竞合"];

    for (let i = 0; i < againJson.length; i++) {
        let allJson = getJsonData(`json/${againJson[i]}.json`);
        allJson[userId] = {};
        changeJsonData(`json/${againJson[i]}.json`, allJson);
    }

    let userJson = getJsonData("json/基础数据.json");
    let writeBaseAll = userJson;
    writeBaseAll[userId] = {
        "初始资金": 500,
        "天数":1,
        "结算":500,
        "广州府介绍": true, //广州府第一次介绍：true
        // "酒馆雇佣": false, //酒馆已选择雇佣工人：true
        "酒馆剧情": HARITYPE.未开始, //酒馆剧情：默认未开始，已开始需要SWOT确认
        "当前线索确认": NOWCLUE.未开始,
        "商行选择":false,
        "SWOT": false,
        "ROI": false,
        "竞合": false
    }

    //写入json
    changeJsonData("json/基础数据.json", writeBaseAll);
    
    return successResult();
}










