
let fs = require('fs');
let path = require('path');


//对象判空
export function objectKeyIsNull(obj, ...keyNames) {
    let isNull = false;
    for (let i = 0; i < keyNames.length; i++) {
        let keyStr = keyNames[i];
        let moreKeyList = keyStr.split(".");
        let lastObj;
        for (let j = 0; j < moreKeyList.length; j++) {
            lastObj = obj[moreKeyList[j]];
            if (!lastObj) {
                isNull = true;
                break;
            }
        }
        if (isNull) break;
    }
    return isNull;
}


/**
 * 随机服务次数 1-5
 * @param min 
 * @param max 
 * @returns 
 */
export function getRandomInt(min, max) {  
    min = Math.ceil(min);  
    max = Math.floor(max);  
    return Math.floor(Math.random() * (max - min + 1)) + min;  
}


/**
 * 获取原有的数据json
 * @param jsonName json文件名称
 * @returns 
 */
export async function getJsonData(jsonName) {
    let filename = path.join(__dirname.substring(0,__dirname.indexOf(`out`)), `json/${jsonName}`);

    let jsonObject = fs.readFileSync(filename, 'utf-8');
    let baseData;
    if (jsonObject) baseData = JSON.parse(jsonObject);
    console.log(baseData);
    return baseData;
}


/**
 * 获取对应登录用户的数据json
 * @param jsonName json文件名称
 * @returns 
 */
export async function getUserJsonData(jsonName, userId) {
    let filename = path.join(__dirname.substring(0,__dirname.indexOf(`out`)), `json/${userId}/${jsonName}`);

    let jsonObject = fs.readFileSync(filename, 'utf-8');
    let baseData;
    if (jsonObject) baseData = JSON.parse(jsonObject);
    console.log(baseData);

    return baseData;
}


/**
 * 更新json数据
 * @param jsonName json文件名称
 */
export async function changeJsonData(jsonName, data) {
    let jsonData = JSON.stringify(data, null, 2);
    let filename = path.join(__dirname.substring(0,__dirname.indexOf(`out`)), `json/${jsonName}`);

    fs.writeFileSync(filename, jsonData);
    console.log('文件写入成功');
    // fs.writeFile(filename, jsonData, (err) => {
    //     if (err) {
    //         console.log(`写入${jsonName}文件失败`);
    //     }
    //     console.log('文件写入成功');
    // });
}


/**
 * 更新对应用户json数据
 * @param jsonName json文件名称
 */
 export async function changeUserJsonData(jsonName, userId, data) {
    let jsonData = JSON.stringify(data, null, 2);
    let filename = path.join(__dirname.substring(0,__dirname.indexOf(`out`)), `json/${userId}/${jsonName}`);

    fs.writeFileSync(filename, jsonData);
    console.log('文件写入成功');

    // fs.writeFile(filename, jsonData, (err) => {
    //     if (err) {
    //         console.log(`写入${jsonName}文件失败`);
    //     }
    //     console.log('文件写入成功');
    // });
}


/**
 * 添加对应user的文件夹
 * @param userId 
 */
export function addJson(userId) {
    /**判断没有当前登录用户的文件夹则新建一个 */
    let dirPath = path.join(__dirname.substring(0,__dirname.indexOf("out")), `json/${userId}`);
    if (!fs.existsSync(dirPath)) {
        try {
            fs.mkdirSync(dirPath, { recursive: true });
            console.log(`文件夹${dirPath}已成功创建`);
            // 指定你要创建的 JSON 文件的路径和名称
            let jsonName = ["雇佣选择.json", "基础数据.json", "竞合.json", "全部线索.json", "提交分数.json", "细分线索.json", "ROI.json", "SWOT.json"];
            for(let i = 0; i < jsonName.length; i++) {
                let jsonFilePath = path.join(dirPath, `${jsonName[i]}`);
                // 转换为 JSON 字符串
                let jsonData = '';
                let jsonString = JSON.stringify(jsonData, null, 2)
                // 文件夹创建成功后，写入 JSON 文件
                fs.writeFileSync(jsonFilePath, jsonString);
                console.log('文件写入成功');
            }
        } catch (err) {
            console.error(`文件夹${dirPath}创建失败${err.message}`);
        }
    } else {
        console.log(`文件夹${dirPath}已存在`);
    }

}









