import { getBizMsg } from "../config/errorEnum";
import { logError } from "./log";

export class BizError extends Error {
    constructor(...msgs) {
        let reqErrorMsg = '';
        let logErrorMsg = '';
        for (let i = 0; i <msgs.length; i++) {
            if (!i) {
                let msg = getBizMsg(msgs[i]);
                reqErrorMsg = msg;
                logErrorMsg = msg;
            } else {
                logErrorMsg += ` | ${msgs[i]} `;
            }
        }

        logError(logErrorMsg);
        super(reqErrorMsg);
    }
}

