
import { planarArrDecollateForIndex, planarArrDeconstruct, planarArrForObjectList } from "../../dataPackage/planaryArrayAnalysis";
import { onceSheetBecomeOfblockData } from "../../util/analysisExcel";

function packageDataProcess(blockDataList, titltListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList) {
    let result = {};

    for (let i = 0; i < blockDataList.length; i++) {
        let {blockData, blockTitle} = blockDataList[i];
        if (keyValueOrTitleList.indexOf(blockTitle) > -1) {
            let titleList = titltListConfig[blockTitle] || [];
            result[blockTitle] = planarArrForObjectList(blockData, 0, titleList);
        }
        else if (barChartList.indexOf(blockTitle) > -1) {
            result[blockTitle] = planarArrDeconstruct(blockData);
        }
        else if (stringList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrForObjectList(blockData);
        else if (decollatePlanarList.indexOf(blockTitle) > -1) result[blockTitle] = planarArrDecollateForIndex(blockData);
    }

    return result;
}



/**
 * 创新游戏
 * @returns 
 */
 export function cxyxTableData() {
    let blockDataList = onceSheetBecomeOfblockData('创新游戏.xlsx', '对话'); //excel表名 sheet名称

    let keyValueOrTitleList = ['对话']; //适配 饼图 键值以及需要多个Key的
    let barChartList = []; //适配 柱状图 折线图
    let stringList= [];
    let decollatePlanarList = []; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}



/**
 * 剧情表
 * @returns 
 */
export function juqingTableData(type, playId) {
    let blockDataList = onceSheetBecomeOfblockData('剧情表.xlsx', `${type}`); //excel表名 sheet名称
    
    // let blockTitleList = {};
    // let keyToLookup;
    // blockDataList.forEach( info => {
    //     let blockTitle = info.blockTitle;
    //     let hasUndersocre = blockTitle.includes('_');

    //     if (hasUndersocre) {
    //         keyToLookup = `${playId}_${duihua}`
    //     } else {
    //         keyToLookup = playId;
    //     }

    // })

    let keyValueOrTitleList = [`${playId}`]; //适配 饼图 键值以及需要多个Key的
    // if (playId) keyValueOrTitleList.push(playId);
    let barChartList = []; //适配 柱状图 折线图
    let stringList= [];
    let decollatePlanarList = []; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


/**
 * NPC
 * @param type 
 * @param playId 
 * @returns 
 */
export function NPCTableData() {
    let blockDataList = onceSheetBecomeOfblockData('剧情表.xlsx', 'NPC'); //excel表名 sheet名称
    
    let keyValueOrTitleList = ['NPC']; //适配 饼图 键值以及需要多个Key的
    let barChartList = []; //适配 柱状图 折线图
    let stringList= [];
    let decollatePlanarList = []; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


/**
 * 线索表
 * @returns 
 */
export function xiansuoTableData() {
    let blockDataList = onceSheetBecomeOfblockData('线索表.xlsx', 'Sheet1'); //excel表名 sheet名称

    let keyValueOrTitleList = ['线索表']; //适配 饼图 键值以及需要多个Key的
    let barChartList = []; //适配 柱状图 折线图
    let stringList= [];
    let decollatePlanarList = []; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}


/**
 * 雇佣表
 * @returns 
 */
export function guyongTableData() {
    let blockDataList = onceSheetBecomeOfblockData('线索表.xlsx', 'Sheet2'); //excel表名 sheet名称

    let keyValueOrTitleList = ['雇佣表', '运输', '原材料', '制作瓷器']; //适配 饼图 键值以及需要多个Key的
    let barChartList = []; //适配 柱状图 折线图
    let stringList= [];
    let decollatePlanarList = []; //适配 表格
    let titleListConfig = {};

    let result = packageDataProcess(blockDataList, titleListConfig, keyValueOrTitleList, barChartList, stringList, decollatePlanarList);
    return result;
}




























