/**
 * SWOT线索
 * 50：SWOT线索总分数 (该公式计算错误：N/M*（1/4）*50)
 * 分数计算规则：N/M*50
 * M：线索总数
 * N：选对线索数
 * 1/4：细分线索类型数量(S、W、O、T)
 */

import { HARITYPE, NOWCLUE } from "../config/enum";
import { successResult } from "../tools/systemTools";
import { changeUserJsonData, getUserJsonData } from "../util/tools";


/**
 * SWOT线索确认
 * @param subdivide  细分线索类型【S、W、O、T】
 * @param xs [{xsid:"", xsnr:""}, ...]
 */
 export async function submitSWOTClue(userId, subdivide, xs) {
    let jsonData = await getUserJsonData("SWOT.json", userId);

    /**处理确认选择的线索 */
    let SWOTClueData = jsonData;
    //没有对应用户数据先添加一个基础格式，有的话直接push
    if (!SWOTClueData || Object.keys(SWOTClueData).length === 0) {
        SWOTClueData = {
            "isSubmit": false,
            "S": [],
            "W": [],
            "O": [],
            "T": []
        };
    }

    //isSubmit:false【未提交】、true【提交】
    /**当前线索类型未提交时，可以修改添加线索 */
    if (!SWOTClueData["isSubmit"]) {
        for (let i = 0; i < xs.length; i++) {
            // let xsInfo = xs[i];
            SWOTClueData[subdivide].push(xs[i]);
        }
        await changeUserJsonData("SWOT.json", userId, SWOTClueData);
        console.log("添加SWOT线索成功");
    } else {
        console.log("线索已提交，无法重复提交");
    }
    
    /**修改全部线索.json的对应线索为已选择 isChoice：true */
    let allClueJson = await getUserJsonData("全部线索.json", userId);
    let allClueData = allClueJson;

    xs.forEach( info => {
        let {xsid, xsnr} = info;
        for(let key in allClueData) {
            allClueData[key].forEach( thisClue => {
                if(xsid == thisClue.xsid) thisClue.isChoice = true; 
            })
        }
    });
    
    await changeUserJsonData("全部线索.json", userId, allClueData);

    let baseJsonData = await getUserJsonData("基础数据.json", userId);
    baseJsonData["当前线索确认"] = NOWCLUE.SWOT;
    if (baseJsonData["酒馆剧情"] < HARITYPE.已开始) baseJsonData["酒馆剧情"] = HARITYPE.已开始;
    await changeUserJsonData("基础数据.json", userId, baseJsonData);

    return successResult();
}


/**
 * 计算选择正确的SWOT线索
 * @param userId
 */
export async function checkSWOT(userId) {
    /**获取细分线索 */
    let xfclueJson = await getUserJsonData("细分线索.json", userId);
    let clueJson = await getUserJsonData("SWOT.json", userId);

    let sumClue = 0; //线索总数
    let rightClue = 0; //选对线索数

    let xfclueSWOTJson = xfclueJson["SWOT"];
    let conf = ["S", "W", "O", "T"];
    
    for (let i = 0; i < conf.length; i++) {
        let allxf = xfclueSWOTJson[conf[i]] || []; //所有细分的线索
        sumClue += allxf.length;
        let rightXf = clueJson[conf[i]] || []; //选中提交的细分线索

        for (let xf = 0; xf < allxf.length; xf++) {
            rightXf.forEach( info => {
                if (allxf[xf] == info.xsid) rightClue++; //计算当前选对线索数
            })
        }
    }
    /**计算分数 */
    let score = 0;
    // score = rightClue/sumClue*(1/4)*50;
    score = (rightClue/sumClue)*50;
    let submitJsonData = await getUserJsonData("提交分数.json", userId);
    let submitScore = submitJsonData;
    submitScore["SWOT"] = score;
    await changeUserJsonData("提交分数.json", userId, submitScore);

    return successResult();
}





