/**
 * 剧情
 */

import { HARITYPE, NOWCLUE } from "../config/enum";
import { systemConfig } from "../config/serverConfig";
import { guyongTableData, juqingTableData, NPCTableData, xiansuoTableData } from "../data/table/tableData";
import { successErrorResult, successResult } from "../tools/systemTools";
import { changeUserJsonData, getJsonData, getUserJsonData } from "../util/tools";
import { xfxxClue } from "./clue";

/**
 * 剧情
 * @param type 游戏板块【对应excel剧情表的sheet名称】
 * @param playId 剧情id
 * @param dhId 对话id(后置剧情id)
 * @param jqqz 绑定剧情权重
 * @returns 
 */
export async function getPlayData(userId:string, type:string, playId:string, dhId:string, jqqz:string) {
    let allClueJson = await getUserJsonData("基础数据.json", userId);
    let hireData = await getUserJsonData("雇佣选择.json", userId);
    let hireWorker = hireData;

    let bdjqqz = JSON.parse(jqqz);
    let weight = weightedRandomChoice(bdjqqz);
    let duihua = `${playId}_${weight}`;
    // let duihua = playId;
    if (playId == "S021") {
        // duihua = `${playId}_1`;
        if (allClueJson["酒馆剧情"] > HARITYPE.未开始) {
            duihua = `${playId}_${allClueJson["酒馆剧情"]}`;
        }
    }
    
    /**获取玩家昵称 */
    let userData = await getJsonData("用户.json");
    let name = "";
    userData.forEach( info => {
        if (info.userId == userId) {
            if (info["name"]) name = info["name"]
            else name = info.loginId;
        }
    })

    let excelData = juqingTableData(type, duihua);
    if (!excelData || Object.keys(excelData).length === 0) return successErrorResult("该NPC暂未开通剧情");//剧情走完添加对应用户的对应线索数据
    let playData = excelData[duihua].dataList;

    //存储下一个剧情的信息
    let nextStory:any = {};
    playData.forEach( async info => {
        let {dhid, dh, jqlx, hzjqid, glnpc, glxsid} = info;

        if (dhid == dhId) {
            //根据传入的id查找对应对话
            nextStory = info;
            nextStory["img"] = `${systemConfig.ipUrl}NPC/${glnpc}.png`;
            if(nextStory.dhlx == "玩家") nextStory.glnpc = name;

            //记录当前走到的剧情
            await plotClues(userId, type, playId, dhId, glxsid);
            //剧情走完添加对应用户的对应线索数据
            await addAllClueByPlan(userId, glxsid);
        }
    });

    if (nextStory) {
        let dhStory = [];
        if(nextStory.jqlx == "选择") {
            nextStory.hzjqid = JSON.parse(nextStory.hzjqid);
            for (let i = 0; i < nextStory.hzjqid.length; i++ ) {
                let dhData = playData.find(s => s.dhid == nextStory.hzjqid[i]);
                await addAllClueByPlan(userId, dhData.glxsid);
                dhData["ispop"] = false;
                if(dhData.jqlx == "工人" || dhData.jqlx == "画师" || dhData.jqlx == "掌柜") {
                    dhData.ispop = true;
                }

                if(dhData) dhStory.push(dhData);
            }
            nextStory.hzjq = dhStory;
            nextStory.img = `${systemConfig.ipUrl}NPC/${nextStory.glnpc}.png`
            if(nextStory.dhlx == "玩家") nextStory.glnpc = name;
        }

        /**运输选择 */
        if (nextStory.glnpc == "邢万里" && nextStory.hzjqid == "999") {
            if (!hireWorker) hireWorker = {};
            hireWorker["运输"] = nextStory.glxsid;
            await changeUserJsonData("雇佣选择.json", userId, hireWorker);
        }

        if (nextStory.hzjqid == '999') {
            await xfxxClue(userId);
            /**剧情完成可添加SWOT线索 */
            if (type == "码头") {
                allClueJson["SWOT"] = true;
            } else if (type == "酒馆") {
                allClueJson["酒馆剧情"] = HARITYPE.已选择;
                //酒馆剧情观看完毕、颜料瓷器已选择、SWOT已确认、工人已选择、运输方式已选择
                if(allClueJson["酒馆剧情"] == HARITYPE.已选择 && allClueJson["商行选择"] && hireWorker["运输"]) allClueJson["ROI"] = true;
            }
            
            //更新json数据
            await changeUserJsonData("基础数据.json", userId, allClueJson);
        }
    }

    return nextStory;
}


/**
 * 获取对应游戏板块的NPC
 * @param type 
 * @returns 
 */
export async function getNPCData(type) {
    let excelData = NPCTableData();
    let npcData = excelData['NPC'].dataList;

    let npcByType = [];
    npcData.forEach( info => {
        let {mc, lx, npc, dyjqid, jqqz} = info;

        if(lx == type) {
            npcByType.push({name:mc, type:lx, img:`${systemConfig.ipUrl}NPC/${mc}.png`, npc, jqid:dyjqid, jqqz})
        }
    })

    return npcByType;
}


/**
 * 剧情相关线索
 */
export async function plotClues(userId:string, type:string, playId:string, dhId:string, glxsid:string) {
    //获取已有json数据
    let baseData = await getUserJsonData("基础数据.json", userId);

    let userData = {};
    if(Object.keys(baseData).length === 0) { //没有对应数据的情况
        userData = {
            "初始资金": 500,
            "天数":1,
            "结算":500,
            "广州府介绍": true, //广州府第一次介绍：true
            "酒馆剧情": HARITYPE.未开始, //酒馆已选择雇佣工人：true
            "当前线索确认": NOWCLUE.未开始,
            "商行选择":false,
            "SWOT": false,
            "ROI": false,
            "竞合": false
        }
        userData[type] = {};
        if (Object.keys(userData[type]).length === 0) {
            userData[type][playId] = {"当前对话id": dhId, "已获得的线索":[]};
            
            if (glxsid) {
                let fruitsEmpty;
                if(glxsid.includes('，') || glxsid.includes(',')) fruitsEmpty = glxsid.split(/\s*[，,]\s*/);
                else fruitsEmpty = [glxsid];

                if(!userData[type][playId]["已获得的线索"]) userData[type][playId]["已获得的线索"] = fruitsEmpty
                else {
                    for(let i = 0; i < fruitsEmpty.length; i++) {
                        fruitsEmpty[i] = fruitsEmpty[i].replace(/^\s+/, '');
                        userData[type][playId]["已获得的线索"].push(fruitsEmpty[i]);
                        let uniqueArray = [...new Set(userData[type][playId]["已获得的线索"])];
                        userData[type][playId]["已获得的线索"] = uniqueArray;
                    }
                }
            }
        }
    } else { //已经有对应数据
        userData = baseData;
        if (!userData[type]) {
            userData[type] = {};
            if(!userData[type][playId]) userData[type][playId] = {"当前对话id":"", "已获得的线索":[]};
            userData[type][playId]["当前对话id"] = dhId;
            userData[type][playId]["已获得的线索"] = [];
            
            if (glxsid) {
                let fruitsEmpty;
                if(glxsid.includes('，') || glxsid.includes(',')) fruitsEmpty = glxsid.split(/\s*[，,]\s*/);
                else fruitsEmpty = [glxsid];

                if(!userData[type][playId]["已获得的线索"]) userData[type][playId]["已获得的线索"] = fruitsEmpty
                else {
                    for(let i = 0; i < fruitsEmpty.length; i++) {
                        fruitsEmpty[i] = fruitsEmpty[i].replace(/^\s+/, '');
                        userData[type][playId]["已获得的线索"].push(fruitsEmpty[i]);
                        let uniqueArray = [...new Set(userData[type][playId]["已获得的线索"])];
                        userData[type][playId]["已获得的线索"] = uniqueArray;
                    }
                }
            }
        } else {
            if (userData[type][playId]) {
                if (userData[type][playId]["当前对话id"] == dhId) return;
                else userData[type][playId]["当前对话id"] = dhId;
            } else userData[type][playId] = {"当前对话id":dhId};
            // userData[type][playId]["当前对话id"] = dhId;
            if (glxsid) {
                let fruitsEmpty;
                if(glxsid.includes('，') || glxsid.includes(',')) fruitsEmpty = glxsid.split(/\s*[，,]\s*/);
                else fruitsEmpty = [glxsid];

                if(!userData[type][playId]["已获得的线索"]) userData[type][playId]["已获得的线索"] = fruitsEmpty
                else {
                    for(let i = 0; i < fruitsEmpty.length; i++) {
                        fruitsEmpty[i] = fruitsEmpty[i].replace(/^\s+/, '');
                        /**剧情相关线索 */
                        userData[type][playId]["已获得的线索"].push(fruitsEmpty[i]);
                        let uniqueArray = [...new Set(userData[type][playId]["已获得的线索"])];
                        userData[type][playId]["已获得的线索"] = uniqueArray;
                    }
                }
            }
        }
    }
    //更新json数据
    await changeUserJsonData("基础数据.json", userId, userData);
    console.log("基础数据更新成功");
}


/**
 * 雇佣工人信息表格
 * @param playType 剧情类型 
 * @returns 
 */
export async function pubHire(playType) {
    let excelData = guyongTableData();
    let hireData = excelData['雇佣表'].dataList;

    let titleList = [];
    if (playType == "工人") titleList = ["工人", "月产量", "费用（两/月）"];
    if (playType == "画师") titleList = ["画师", "月产量", "费用（两/月）"];
    if (playType == "掌柜") titleList = ["掌柜", "月产量", "费用（两/月）"];
    
    let hireWorker = {};
    hireData.forEach( info => {
        let type = info.lx;
        if(!hireWorker[type]) hireWorker[type] = [];
        hireWorker[type].push({xsId:info.xsid, ry:info.ry, sjcl:info.sjcl, gz:info.gz});
    });

    return { titleList, dataList:hireWorker[playType] };
}


/**
 * 提交雇佣工人
 * @param playType 剧情类型
 * @param xsId 线索id 
 */
export async function submitHire(userId, playType, xsId) {
    //获取已有json数据
    let hireData = await getUserJsonData("雇佣选择.json", userId);
    let hireWorker = hireData;
    let oldxsid = "";
    if (!hireWorker) hireWorker = {};
    if (!hireWorker["人工"]) hireWorker["人工"] = {};
    else oldxsid = hireWorker["人工"][playType];
    hireWorker["人工"][playType] = xsId;

    await changeUserJsonData("雇佣选择.json", userId, hireWorker);
    console.log(`雇佣${playType}添加成功，线索id${xsId}`);

    /**雇佣工人成功，扣除工资部分 */
    let excelData = guyongTableData();
    let hireExcel = excelData['雇佣表'].dataList;
    let hireMoney = 0;
    let oldgz = 0;
    hireExcel.forEach( info => {
        if (info.xsid == xsId) hireMoney = parseInt(info.gz);
        if (info.xsid == oldxsid) oldgz = parseInt(info.gz);
    });
    //扣除雇佣工人工资
    let baseData = await getUserJsonData("基础数据.json", userId);
    let jisuan = baseData["结算"] || 0;
    baseData["结算"] = jisuan + oldgz - hireMoney;
    await changeUserJsonData("基础数据.json", userId, baseData);

    return successResult();
}


/**回显雇佣工人 */
export async function displayHire(userId) {
    //获取已有json数据
    let hireData = await getUserJsonData("雇佣选择.json", userId);
    let hireWorker = {};
    if (!hireData || Object.keys(hireData).length === 0) hireData = {"人工":{"工人": "", "画师": "", "掌柜": ""}};
    hireWorker = hireData["人工"];

    return hireWorker;
}


/**
 * 颜料、瓷器信息表格
 * @param type 类型 
 * @returns 
 */
export async function rawMaterial(type) {
    let excelData = guyongTableData();
    let rawMaterialData = excelData['原材料'].dataList;

    let titleList = [];
    if (type == "颜料") titleList = ["颜料", "费用（两/个）"];
    if (type == "瓷器") titleList = ["瓷器", "费用（两/个）"];
    
    let rawMaterial = {};
    rawMaterialData.forEach( info => {
        let type = info.lx;
        if(!rawMaterial[type]) rawMaterial[type] = [];
        rawMaterial[type].push({xsId:info.xsid, type:info.lx, mc:info.sjmc, jg:info.jg}); //
    });

    return { titleList, dataList:rawMaterial[type] };
}


/**
 * 提交颜料、瓷器
 * @param type 剧情类型
 * @param xsId 线索id 
 */
export async function submitRawMaterial(userId, type, xsId) {
    //获取已有json数据
    let rawMaterialData = await getUserJsonData("雇佣选择.json", userId);
    let rawMaterial = rawMaterialData;
    let oldxsid = "";
    if (!rawMaterial) rawMaterial = {};
    if (!rawMaterial["原材料"]) rawMaterial["原材料"] = {};
    else oldxsid = rawMaterial["原材料"][type];

    rawMaterial["原材料"][type] = xsId;

    //运输类型默认水路 todo
    // rawMaterial["运输"] = "C037";

    await changeUserJsonData("雇佣选择.json", userId, rawMaterial);
    console.log(`选择${type}添加成功，线索id${xsId}`);

    /**购买原材料成功，扣除原材料价格 */
    let excelData = guyongTableData();
    let rawMaterialExcel = excelData['原材料'].dataList;
    let rawMaterialMoney = 0;
    let oldgz = 0;
    rawMaterialExcel.forEach( info => {
        if (info.xsid == xsId) rawMaterialMoney = parseInt(info.jg);
        if (info.xsid == oldxsid) oldgz = parseInt(info.jg);
    });

    //扣除100个瓷器和颜料的价格 todo
    let baseData = await getUserJsonData("基础数据.json", userId);
    let jsje = baseData["结算"] || 0;
    baseData["结算"] = jsje + oldgz*1000 - rawMaterialMoney*1000;
    
    baseData["商行选择"] = true;
    //酒馆剧情观看完毕、颜料瓷器已选择、SWOT已确认、工人已选择
    if(baseData["酒馆剧情"] == HARITYPE.已选择 && baseData["商行选择"]) baseData["ROI"] = true;
    await changeUserJsonData("基础数据.json", userId, baseData);

    return successResult();
}


/**
 * 回显颜料、瓷器
 * @param userId 
 * @returns 
 */
export async function displayRawMaterial(userId) {
    //获取已有json数据
    let hireData = await getUserJsonData("雇佣选择.json", userId);
    let hireWorker = {};
    if (!hireData || Object.keys(hireData).length === 0) hireData = {"原材料":{"瓷器":"", "颜料":""}};
    hireWorker = hireData["原材料"];

    return hireWorker;
}


/**
 * 广州府是否第一次阅读
 * @param userId 
 */
export async function getGzf(userId) {
    //获取已有json数据
    let baseJsonData = await getUserJsonData("基础数据.json", userId);
    let firstGzf = baseJsonData["广州府介绍"];
    let writeBaseAll = baseJsonData;
    writeBaseAll["广州府介绍"] = false;
    
    await changeUserJsonData("基础数据.json", userId, writeBaseAll);

    return {firstGzf};
}


/**
 * 广州府介绍
 * @param userId 
 */
export async function getIntroduceGzf(userId) {
    //获取已有json数据
    let baseJsonData = await getJsonData("广州府介绍.json");

    //获取已有json数据
    let baseData = await getUserJsonData("全部线索.json", userId);

    /**获取表格数据 */
    let excelData = xiansuoTableData();
    let clueExcelData = excelData["线索表"].dataList;

    let userData = baseData;
    //没有对应数据的情况
    if(!baseData || Object.keys(baseData).length === 0) userData = {};
    clueExcelData.forEach( info => {
        let {xsid, xsnr, xslx, xslxxf, dhgl, sfbx} = info;
        if (!userData) userData = {};
        if (!userData[xslx]) userData[xslx] = [];
        //匹配线索id
        if (dhgl == "开篇1" || dhgl == "开篇2") {
            //检查数组中是否已经有对象的xsid等于当前xsid
                    let exists = userData[xslx].find(s => s.xsid == xsid);
            //如果不存在，则添加该线索
            if (!exists) {
                userData[xslx].push({xsid, xsnr, isChoice:false, sfbx});
            }
        }
    })
    
    await changeUserJsonData("全部线索.json", userId, userData);
    console.log("已添加全部线索");

    return baseJsonData;
}


/**
 * 是否能进入酒馆剧情
 * @param userId 
 */
export async function firstPubHire(userId) {
    let baseJsonData = await getUserJsonData("基础数据.json", userId);
    let isEnabled = false;
    /**判断是否确认SWOT线索 */
    if (baseJsonData["酒馆剧情"] > HARITYPE.未开始) isEnabled = true;
    
    return {isEnabled};
}


/**
 * 根据剧情关联线索添加
 * @param userId 
 * @param glxsid 
 */
export async function addAllClueByPlan(userId, glxsid) {
    //获取已有json数据
    let baseData = await getUserJsonData("全部线索.json", userId);

    /**获取表格数据 */
    let excelData = xiansuoTableData();
    let clueExcelData = excelData["线索表"].dataList;

    let userData = baseData;
    //没有对应数据的情况
    if(Object.keys(baseData).length === 0) userData = {};
    /**关联的线索 */
    if (glxsid) {
        let fruitsEmpty;
        if(glxsid.includes('，') || glxsid.includes(',')) fruitsEmpty = glxsid.split(/\s*[，,]\s*/);
        else fruitsEmpty = [glxsid];

        for(let i = 0; i < fruitsEmpty.length; i++) {
            fruitsEmpty[i] = fruitsEmpty[i].replace(/^\s+/, '');
        }

        let distinctMap = {};//用于去重线索的map
        if (!userData) userData = {};
        for (let xslx in userData) {
            distinctMap[xslx] = {};
            userData[xslx].forEach(info => {
                let {xsid} = info;
                distinctMap[xslx][xsid] = info;
            });
        }

        clueExcelData.forEach(info => {
            let {xsid, xsnr, xslx, xslxxf, dhgl, sfbx} = info;
            if (fruitsEmpty.indexOf(xsid) > -1) {
                //命中
                if (distinctMap[xslx][xsid]) return;

                //去重之后的并且需要添加
                if (!userData[xslx]) userData[xslx] = [];
                userData[info.xslx].push({xsid, xsnr, isChoice:false, sfbx});
            }

        });

    }
    
    await changeUserJsonData("全部线索.json", userId, userData);
    console.log("已添加全部线索");
}


/**
 * 权重选择剧情
 * @param arr 传入NPC对应的所有剧情选项
 * @returns 
 */
export function weightedRandomChoice(arr) {
    // 计算权重(使用平方)
    const weights = arr.map(num => num * num);
    // 计算总权重
    const totalWeight = weights.reduce((sum, weight) => sum + weight, 0);

    // 创建累计权重数组
    const cumulativeWeights = [0];
    let cumulativeSum = 0;
    for (let weight of weights) {
        cumulativeSum += weight;
        cumulativeWeights.push(cumulativeSum);
    }

    //生成一个0到总权重之间的随机数
    const randomValue = Math.random() * totalWeight;

    //使用累积权重数组来确定选择的索引
    for (let i = 0; i < cumulativeWeights.length; i++) {
        if(randomValue < cumulativeWeights[i]) {
            return arr[i - 1]; //数组索引从0开始，所以返回i-1对应的元素（被选中的选项）
        }
    }

    //理论上这里不应该到达，因为累积权重应该覆盖所有情况
    return arr[arr.length - 1]; //返回最后一个选项作为默认值
}




