let log4js = require('log4js');
let path = require('path');

//log路径
export const systemLogPath = {
    errorLogFile:"error",
    errorLogDir:"error",
    handleLogFile:"handle",
    handleLogDir:"handle"
}

//日志根目录
// let baseLogPath = path.resolve(__dirname.substring(0, __dirname.indexOf("out")), 'logs');
let baseLogPath = path.resolve('./', 'logs');
let errFile = path.resolve(baseLogPath, systemLogPath.errorLogDir, systemLogPath.errorLogFile);
let handFile =path.resolve(baseLogPath, systemLogPath.handleLogDir, systemLogPath.handleLogFile);
let config = {
    appenders:
        {
            "rule-console": {"type": "console"},
            "errorLogger": {
                "type": "dateFile", // 日志类型
                "filename": errFile, // 输出文件名
                "pattern": "-yyyy-MM-dd.log", // 后缀
                "alwaysIncludePattern": true, // 上面两个参数是否合并
                "encoding": "utf-8", // 编码格式
                "maxLogSize": 1000, // 最大存储内容
                "numBackups": 3, // 当文件内容超过文件存储空间时，备份文件的数量
                "path": `/${systemLogPath.errorLogDir}`
            },
            "handleLogger": {
                "type": "dateFile",
                "filename":  handFile,
                "pattern": "-yyyy-MM-dd.log",
                "alwaysIncludePattern": true,
                "encoding": "utf-8",
                "maxLogSize": 1000,
                "numBackups": 3,
                "path": `/${systemLogPath.handleLogDir}`
            }
          
        },
    categories: {
        "default": {"appenders": ["rule-console"], "level": "all"}, //这个配置一定要有
        "errorLogger": {"appenders": ["errorLogger"], "level": "error"},
        "handleLogger": {"appenders": ["handleLogger"], "level": "all"}
    },
    "baseLogPath": path.resolve(baseLogPath, systemLogPath.handleLogDir, systemLogPath.handleLogFile)
};

log4js.configure(config);  //加载配置文件

//调用预先定义的日志名称
let errorLogger = log4js.getLogger("errorLogger");
let handleLogger = log4js.getLogger("handleLogger");
let consoleLogger = log4js.getLogger("rule-console");

//错误日志
export function logError(...errStrs) {
    let str = "";
    errStrs.forEach(item => {
        str += item + " |  ";
    });
    errorLogger.error(`errorInfo =>   ${str}`);
}

//普通日志
export function logHandle(msgStr:string) {
    handleLogger.info(`logInfo =>    ${msgStr}`);
}

//输出日志
export function logConsole(logStr:string) {
    consoleLogger.info(`logInfo =>   ${logStr}`);
}
