import { getBizMsg, getSysMsg } from "../config/errorEnum";
import { logError } from "./log";

export class BizError extends Error {
    constructor(...msgs) {
        let reqErrorMsg = '';
        let logErrorMsg = '';
        for (let i = 0; i <msgs.length; i++) {
            if (!i) {
                let msg = getBizMsg(msgs[i]);
                reqErrorMsg = msg;
                logErrorMsg = msg;
            } else {
                logErrorMsg += ` | ${msgs[i]} `;
            }
        }

        logError(logErrorMsg);
        super(reqErrorMsg);
    }
}

export class SysError extends Error {
    constructor(...msgs) {
        let reqErrorMsg = '';
        let logErrorMsg = '';
        for (let i = 0; i <msgs.length; i++) {
            if (!i) {
                let msg= getSysMsg(msgs[i]);
                reqErrorMsg = msg;
                logErrorMsg = msg;
            } else {
                if (typeof msgs[i] == 'object') logErrorMsg += ` | ${JSON.stringify(msgs[i])} `;
                else logErrorMsg += ` | ${msgs[i]} `;
            }
        }

        logError(logErrorMsg);
        super(reqErrorMsg);
    }
}