export async function encryptionReturn(req, res, next) {
    res.on('end', function(){
        console.log(res.body);
    });

    let resSend = res.send;
    res.send = (obj)=>{
        changeNumber(obj);
        //递归修改number型
        resSend.call(res, obj);
    };
    
    next();
}

function changeNumber(obj) {
    if (Array.isArray(obj)) {
        for (let i = 0; i < obj.length; i++) {
            let arrItem = obj[i];
            if (typeof arrItem == "number") {
                obj[i] = getSameLenNumber(arrItem);
            }
            else if (typeof arrItem == "object") {
                changeNumber(arrItem);
            }
        }
    }
    else {
        for (let key in obj) {
            let objItem = obj[key];
            if (typeof objItem == "number") {
                if (key == "x" || key == "y") continue;
                
                obj[key] = getSameLenNumber(objItem);
            }
            else if (typeof objItem == "object") {
                changeNumber(objItem);
            }
        }
    }
}

function getSameLenNumber(num) {
    let numStr = String(num);
    //疑似年份的不做加密
    if (numStr.length == 4 && (numStr.indexOf("19") == 0 || numStr.indexOf("20") == 0)) return num;
    let str = "";
    for (let i = 0; i < numStr.length; i++) {
        if (numStr[i] == '.') str += numStr[i];
        else str += "6";
    }

    return Number(str);
}