//接口任务 定期更新
import moment = require('moment');
import * as request from 'request';
import { SYSTEMERRORENUM } from '../config/errorEnum';
import { BizError, SysError } from "../util/bizError";

let accToken = "";

export async function getInterfaceByInterfaceName(url, body) {
    let headers = {accept: "*/*", Authorization:"Bearer 38a96559-8f70-4df8-87f9-af3eb58fcc27"};
    let reqResult = await post(url, body, headers);
    let {err, res, reqData}:any = reqResult;
    
    let reqErrorMsg = "";
    if (err) reqErrorMsg = err.msg || err.message;
    else if (!reqData.code) reqErrorMsg = reqData.error_msg;
    else {
        switch (reqData.code) {
            case 401: throw new SysError(SYSTEMERRORENUM.获取第三方接口数据失败, url, ` 请求未鉴权`);
            case 404: throw new SysError(SYSTEMERRORENUM.获取第三方接口数据失败, url, ` 请求路径不存在`);
            case 503: throw new SysError(SYSTEMERRORENUM.获取第三方接口数据失败, url, ` 请求频率过高`);
            case 500: throw new SysError(SYSTEMERRORENUM.获取第三方接口数据失败, url, reqData.msg);
        }
    }

    if (reqErrorMsg) throw new SysError(SYSTEMERRORENUM.获取第三方接口数据失败, url, reqErrorMsg);

    let {msg, data, resultData} = reqData;
    
    if (msg) return //小车心跳

    if (!data && !resultData) {
        throw new SysError(SYSTEMERRORENUM.获取第三方接口数据失败, url, `缺少返回参数 data`);
    }

    return data || resultData;
}

//接口方会返回500错误，但是这说明没有监控视频
export async function getCarVideo(url, body) {
    let {err, res, reqData}:any = await get(url, body, {});
    if (reqData.code == 500) {
        return false;
    }
    if (reqData.data || reqData.resultData) return reqData.data || reqData.resultData;
    // return reqData.data;
    return false;
}


function get(url:string, query?, headers?, timeOut?) {
    timeOut = timeOut || 10000;
    if (!url || (url.search(/http:/) && url.search(/https:/)) ) throw new BizError(!url ? "请求地址为空" : "请求地址错误");
    return new Promise((resolve, reject)=>{
        let paramater:any = { url, json:true, timeout:timeOut };
        if (query) paramater.qs = query;
        if (headers) paramater.headers = headers;
        request.get(paramater, function (err, res, reqData) {
            resolve({err, res, reqData});
        })
    })
}


function post(url, body, headers) {
    if (!url || (url.search(/http:/) && url.search(/https:/)) ) throw new BizError(!url ? "请求地址为空" : "请求地址错误");
    let header = {"content-type": "application/json"};  
    return new Promise((resolve, reject)=>{
        request({
            url: url,
            method: "POST",
            json: true,
            headers: Object.assign(header, headers),
            body: body
        }, function(err, res, data) {
            const success = !err && res && res.statusCode == 200;
            let message = err || res.statusCode || "";
            resolve({success, message, reqData:data});
        });
    })
}

function postForm(url, body) {
    if (!url || (url.search(/http:/) && url.search(/https:/)) ) throw new BizError(!url ? "请求地址为空" : "请求地址错误");
    return new Promise((resolve, reject)=>{
        request({
            url: url,
            method: "POST",
            json: true,
            form:body
        }, function(err, res, data) {
            const success = !err && res && res.statusCode == 200;
            let message = err || res.statusCode || "";
            resolve({success, message, data});
        });
    })
}
