const path = require('path');
import * as fs from "fs";
import { BizError, SysError } from "../util/bizError";
import { analysisXml } from "../util/myXML";
import { SYSTEMERRORENUM } from "./errorEnum";
const os = require('os');

export let systemConfig = {
    port:9999,
};

//数据中心接口
export let dataCenterInterfaceConfig = {
    answerText:"",//获取问数结果信息
};

let serverIp = "";

const ConfigName = "serverConfig.xml";
export async function initConfig() {
    try {
        let buff = fs.readFileSync(path.join('./', ConfigName));
        // let buff = fs.readFileSync(path.join(__dirname.substring(0,__dirname.indexOf("out")), ConfigName));
        let configStr = buff.toString();
        let configInfo:any = await analysisXml(configStr);
		if (!configInfo || !configInfo.config) console.log("xml中无配置加载");
		else {
            //必要配置
            let integralConfig = [
                "port", 
                {
                    "dataCenterInterface":[ "answerText" ]
                }
            ];

            
            checkConfig(integralConfig, configInfo.config);
           
            let {port, dataCenterInterface} = configInfo.config;
            systemConfig.port = parseInt(port[0]);

            //数据中心接口
            dataCenterInterfaceConfig.answerText = dataCenterInterface[0].answerText[0];
		}
        
        console.log("config init success");

    } catch(err) {
        throw new BizError("服务器配置解析错误 请检查根目录下 serverConfig.xml 文件是否正确");
    }
}
 

function checkConfig(config, configData) {
    config.forEach(item => {
        if (typeof item == "object") {
            for (let key in item) {
                if (!configData[key] || !configData[key][0]) {
                    throw new SysError(SYSTEMERRORENUM.初始化配置失败, `serverConfig.xml中 缺少 ${key}`);
                }
                item[key].forEach( subItem => {
                    if (!configData[key][0][subItem] || !configData[key][0][subItem][0]) {
                        throw new SysError(SYSTEMERRORENUM.初始化配置失败, `serverConfig.xml中 ${key}缺少 ${subItem}`);
                    }
                });

            }
        } else {
            if (!configData[item] || !configData[item][0]) {
                throw new SysError(SYSTEMERRORENUM.初始化配置失败, `serverConfig.xml中 缺少 ${item}`);
            }
        }
    });
}

//获取内网地址
export function getImageIp() {
    return serverIp;
}
