

export function limitEnteNameString(name, number?) {
    number = number ? number : 13;
    if (name.length > number) return `${name.substring(0,number - 2)}...`;
    return name;
}

const moneyStrConfig = {
    "万亿": 13,
    "萬億": 13, 
    "千亿": 12, 
    "千億": 12, 
    "百亿": 11, 
    "佰億": 11, 
    "十亿": 10, 
    "拾億": 10, 
    "亿": 9, 
    "億": 9, 
    "千万": 8, 
    "千萬": 8, 
    "百万": 7, 
    "佰萬": 7,
    "十万": 6, 
    "拾萬": 6, 
    "万": 5, 
    "萬": 5,
    "千":4,
    "百":3,
    "十":2,
    "美元":1,
    "人名币":1,
    "元":1,
};
// 汇率
let dollarRate = 6.4731;
//解析金额
export function analysisMoneyStr(mnyStr:string) {
    let zeroNum = 1;
    let moneyNumber = 0;
    for (let key in moneyStrConfig) {
        let checkNum = mnyStr.indexOf(key);
        if (checkNum > -1) {
            zeroNum = moneyStrConfig[key];
            moneyNumber = parseFloat(mnyStr.slice(0, checkNum));
            break;
        }
    }
    if (mnyStr.replace(/[^0-9]/ig,"") == "") return 0;


    if (zeroNum > 1) { 
        let count = 1;
        for (let i = 1; i < zeroNum; i++) {
            count = count * 10;
        }
        zeroNum = count;
    }

    let money = parseInt(`${zeroNum * moneyNumber}`);

    if (mnyStr.indexOf('美元')) money = parseInt(`${money * dollarRate}`);

    return money;
}


//缩略金额
export function simplifyMoney(mny:number, str:string) {
    let num = moneyStrConfig[str];

    let count = 1;

    for (let i = 1; i < num; i++) {
        count = count * 10;
    }

    return mny / count;
}

//分离 带单位的数据
function separateDataAndUint(str) {
    if (!str) return {data:0, unit:""};
    let data = str.replace(/[\u4E00-\u9FA5a-zA-Z]+/,"");
    let unit = str.replace(/^(-)?\d+(\.\d+)?/, "");
    return {data, unit};
}

//object key替换 带单位
export function objKeyReplace(object, keyInfo = {}, isString = true) {
    if (isString) {
        //校验字符
        for (let key in object) {
            if (!object[key]) object[key] = '';
        }
    } else {
         //校验数字
         for (let key in object) {
            if (!object[key]) object[key] = '0';
        }
    }
    let unitMap = {};
    let dataMap = {};
    for(let key in object) {
        let newKey = keyInfo[key] || key;
        let {data, unit} = separateDataAndUint(`${object[key]}` || "");
        unitMap[newKey] = unit;
        dataMap[newKey] =  parseFloat(data);
    }
    return {dataMap, unitMap};
}

//返回特定key和value的obj
export function objKeyAndValue(dataMap, ...keyList) {
    let result = {};
    for (let key in dataMap) {
        if ( keyList.indexOf(key) > -1 ) result[key] = dataMap[key];  
    }
    return result;
}

//获取键值数据  percent =>为数字的时候 保留几位小数
export function getKeyValue(title, dataMap, unit, total, percent ) {
    let data = { 
        title, 
        subTitle : title,
        total : 0,
        list : []
    };
    let count = 0;
    for (let key in dataMap) {
        let value = parseFloat(dataMap[key]);
        count += value;
        if (total) data.total += value;
    }
    for (let key in dataMap) {
        let thisUnit = "";
        if (unit) {
            if (typeof unit == "string") thisUnit = unit;
            else thisUnit = unit[key];
        }
        let value = parseFloat(dataMap[key]);
        if (percent) {
            thisUnit = '%';
            value = getDecimalForN( value/count, percent);
        }
        let onceInfo:any = { key, value, unit:thisUnit };
        data.list.push(onceInfo);
    }
    return data;
}

export function getKeyStringValue(title, dataMap) {
    let data = { 
        title, 
        subTitle : title,
        total : 0,
        list : []
    };
    for (let key in dataMap) {
        if (dataMap[key]) {
            data.list.push({
                key,
                value:dataMap[key]
            });
        } else {
            data.list.push({
                key,
                value:""
            });
        }
    }
    return data;
}

function getChartMin(num) {
    if (num > 0) return 0;
    return Math.floor(num);
}

export function getChartData(title, dataMap, unit, percent ) {
    unit = unit || "";
    let data = {
        title, yMaxValue:0, yMinValue:new Date().valueOf(), yStepValue:0, unit : percent ? "%" : unit ,
        data: { title: title , total : 0, list : [ ] }
    }
    let count = 0;
    
    for (let key in dataMap) {
        let value = parseFloat(dataMap[key] || 0);
        data.yMaxValue = Math.max(data.yMaxValue, value);
        data.yMinValue = Math.min(data.yMinValue, value);
        count += 1;
        data.data.total += value;
    }
    
    for (let key in dataMap) {
        let value = parseFloat(dataMap[key]);
        let thisUnit = unit;
        if (percent) {
            thisUnit = '%';
            value = getDecimalForN( value/count, percent);
        }
        let onceInfo = { key, unit:thisUnit, value };
        data.data.list.push(onceInfo)
    }
    data.yMinValue = getChartMin(data.yMinValue);
    data.yStepValue = getChartStepNumber(Math.ceil((data.yMaxValue - data.yMinValue) / count));
    let maxVal = Math.ceil(data.yMaxValue);
    data.yMaxValue =  maxVal+(data.yStepValue - (maxVal%data.yStepValue));

    return data;
}

export function getListData( title, dataList, titleList, titleValueObj ) {
    let data = { title, subTitle:title, total:dataList.length, titleList, valueList:[] };

    dataList.forEach(info => {
        let onceList = [];
        titleList.forEach(titleName => {
            onceList.push(info[ titleValueObj[titleName] ]);
        });
        data.valueList.push(onceList);
    });
   return data;
}


//多个y轴的条柱状图  dataMap => {"name":{"key1":1111,"key2":232, "key3":dsfs, ... }, ... }
export function getMoreYChartData(title, dataMap, percent, unit ) {
    let data = { title, dataList: [] };

    for (let subDataName in dataMap) {
        let onceData =  { title:subDataName, yMaxValue:0, yMinValue:new Date().valueOf(), yStepValue:0, unit:"", total : 0, list : [ ] };

        let thisDataInfo = dataMap[subDataName];

        let thisCount = 0;
        for (let key in thisDataInfo) {
            let value = parseFloat(thisDataInfo[key]);
            onceData.yMaxValue = Math.max(onceData.yMaxValue, value);
            onceData.yMinValue = Math.min(onceData.yMinValue, value);
            onceData.total += value;
            thisCount += 1;
        }

        onceData.yStepValue = getChartStepNumber(Math.ceil( (onceData.yMaxValue - onceData.yMinValue) / thisCount) );

        let thisUnit;
        if (percent) {
            thisUnit = "%";
            onceData.yMaxValue = 100;
            onceData.yStepValue = Math.ceil( (100 - onceData.yMinValue) / onceData.total ) ;
        }
        else if (typeof unit == 'object') {
            thisUnit = unit[subDataName] || "";
        } else thisUnit = unit || "";

        for (let key in thisDataInfo) {
            let value;
            if (percent) value = getDecimalForN( value/onceData.total, percent);
            else value = parseFloat(thisDataInfo[key]);
            let onceInfo = { key, unit:thisUnit, value };
            onceData.list.push(onceInfo)
        }
        
        onceData.total = getDecimalForN( onceData.total, 1);
        let maxVal = Math.ceil(onceData.yMaxValue);
        onceData.yMinValue = getChartMin(onceData.yMinValue);
        onceData.yMaxValue = maxVal+(onceData.yStepValue - (maxVal%onceData.yStepValue));
        data.dataList.push(onceData);
    }

    return data;
}

//一个y轴的多个数据的柱状图
export function getSingleYAndMoreData(title, dataMap, percent, unit) {
    let data = { title, dataList:[], yMaxValue:0, yMinValue:new Date().valueOf(), yStepValue:0, unit:"", total : 0 };

    let maxCount = 0;

    for (let subDataName in dataMap) {
        let onceData =  { title:subDataName, list:[] };
        let thisDataCount = 0;

        let analysisMap = objKeyReplace(dataMap[subDataName])
        let thisData = analysisMap.dataMap;

        let thisMax = 0;
        for (let key in thisData) {
            let value = parseFloat(dataMap[key]);
            thisDataCount += value;
            thisMax += 1;
        }

        maxCount = Math.max(maxCount, thisMax);

        let thisUnit;
        if (percent) thisUnit = "%";
        else if (typeof unit == 'object') {
            thisUnit = unit[subDataName] || "";
        } else thisUnit = unit || "";

        for (let key in thisData) {
            let value;
            if (percent) value = getDecimalForN( value/thisDataCount, percent);
            else value = parseFloat(thisData[key]);

            data.yMaxValue = Math.max(data.yMaxValue, value);
            data.yMinValue = Math.min(data.yMinValue, value);
            data.total += value;

            let onceInfo = { key, unit:thisUnit, value };
            onceData.list.push(onceInfo)
        }

        data.dataList.push(onceData);
    }

    data.yMinValue = getChartMin(data.yMinValue);
    data.yMaxValue = Math.ceil(data.yMaxValue);
    data.yStepValue = getChartStepNumber( Math.ceil((data.yMaxValue - data.yMinValue) / maxCount));

    return data;
}

function getChartStepNumber(number) {
    let lenth = `${number}`.length;
    let count = 1;
    for (let i = 1; i < lenth; i++) {
        count = count * 10;
    }
    return number + ( count - (number % count) );
}

//字符模板
export function getStringMoreData(title, valueList) {
    let result = { title, data:{} };
    valueList.forEach( (info, index) => {
        let key = index + 1
        result.data[`${key}`] = info;
    });
    return result;
}

//撒点图  cutApartXAndY:[分割的x坐标，分割的y坐标]
export function getDropMoreData(dataList, title, subTitle, cutApartXAndY?) {
    let data:any = {title, subTitle, dataList:[], xMax:0, xMin:new Date().valueOf(), yMax:0, yMin:new Date().valueOf() };

    dataList.forEach(info => {
        let {x, y} = info;
        let thisDropXInfo = separateDataAndUint(`${x}`);
        let thisDropX = parseFloat(thisDropXInfo.data);
        let thisDropYInfo = separateDataAndUint(`${y}`);
        let thisDropY = parseFloat(thisDropYInfo.data);

        data.xMax = Math.max(thisDropX, data.xMax);
        data.xMin = Math.min(thisDropX, data.xMin);

        data.yMax = Math.max(thisDropY, data.yMax);
        data.yMin = Math.min(thisDropY, data.yMin);

        let value = [thisDropX, thisDropY];
        let type = 1;
        if (cutApartXAndY) {
            let cutX = cutApartXAndY[0];
            let cutY = cutApartXAndY[1];
            if ( thisDropX  < cutX && thisDropY > cutY) type = 1;
            else if ( thisDropX > cutX && thisDropY > cutY ) type = 2;
            else if (  thisDropX  < cutX && thisDropY < cutY ) type = 3;
            else type = 4;
        }
    
        data.dataList.push({value, name:info.name||"", type});
    });

    if (cutApartXAndY) {
        data.cutApartX = cutApartXAndY[0];
        data.cutApartY = cutApartXAndY[1];
    }

    let count = dataList.length;
    let xAvg = Math.ceil((data.xMax - data.xMin) / count);
    data.xMax = Math.floor( data.xMax + xAvg);
    data.xMin = Math.floor( data.xMin - xAvg);

    let yAvg = Math.ceil((data.yMax - data.yMin) / count);
    data.yMax = Math.floor( data.yMax + yAvg);
    data.yMin = Math.floor( data.yMin - yAvg);

    return data;
}

//按需取保留小数长度 tenNumber保留小数位 1位就填1
export function getDecimalForN(number, n) {
    let ten = 1;

    for (let i = 0; i < n; i ++) {
        ten = ten * 10;
    }

    return Math.ceil(number * ten) / ten
}

//生日获取时间段
export function getAgeByBirthday(birthday:string) {
    let b = new Date(birthday).valueOf();
    let d = new Date().valueOf();

    let onceYear = 365 * 24 * 3600 * 1000;

    let age = Math.floor( (d - b) / onceYear );

    if (age >= 21 && age <= 30 ) return "21-30";
    else if (age >= 31 && age <= 40 ) return "35-45";
    else if (age >= 41 && age <= 50 ) return "46-55";
    else if (age > 50) return "50岁以上";
    else return '其他';
}

export function analysisAddOrRMData(str) {
    str = `${str}`;
    let checkStr = str.replace(/增加/, "");
    let result = checkStr.replace(/减少/, "-");
    return result;
}

export function changeDataName(str) {
    let result = str.replace(/[()""“”/（）-]/, "_");
    for (let i =0; i < 10; i++) {
        result = result.replace(/[()""“”/（）-]/, "_");
    }
    return result;
}

//数据保留两位小数
export function getDataMapDecimalForN(dataMap, number?) {
    let tenCount = number ? number : 2;
    let result = {};
    for (let key in dataMap) {
        let value = dataMap[key];
        if (typeof value == 'string') {
            let {data } = separateDataAndUint(value);
            value = parseFloat(data);
        }
        result[key] = getDecimalForN(value, tenCount);
    }
    return result;
}