export enum ERRORENUM {
    未找到数据,
    参数错误
}
export enum SYSTEMERRORENUM {
    初始化配置失败 = 1,
    获取第三方接口数据失败,
    未按接口协议返回,
    请求未鉴权 = 401,
    请求路径不存在 = 404,
    请求频率过高 = 503
}

let bizErrorMsgMap = {};
for (let key in ERRORENUM) {
    bizErrorMsgMap[ERRORENUM[key]] = key;
}

let systemErrorMsgMap = {};
for (let key in SYSTEMERRORENUM) {
    systemErrorMsgMap[SYSTEMERRORENUM[key]] = key;
}

export function getBizMsg(param) {
    return bizErrorMsgMap[param];
}

export function getSysMsg(param) {
    return systemErrorMsgMap[param];
}