import moment = require("moment");
import { SYSTEMERRORENUM } from "../../config/errorEnum";
import { dataCenterInterfaceConfig } from "../../config/serverConfig";
import { SysError } from "../../util/bizError";
import { getInterfaceByInterfaceName } from "../cronJob";
import { AIANSWERTYPE } from "../../config/enum";


//ai智能问答
export async function getAIAnswerInterface(question, sceneUuids, threadId) {
    const interfaceName = "获取问数结果信息";
    let body = {question, sceneUuids, threadId};
    // let data = await getInterfaceByInterfaceName( dataCenterInterfaceConfig.answerText, body );

    /**----------------test */
    // let sample = {header:[], data:[]};
    // if (question == "营销项目三明市商务局2025年“福建有口福”餐饮促消费活动今年共出奖多少钱") {
    //     sample.header = ["餐饮促消费活动今年共出奖"];
    //     sample.data = [["1000000"]];
    // }

    // if (question == "假设今天是2025年3月份的一天，项目25S3135000703单用户和单商户分别投入多少") {
    //     sample.header = ["单用户投入（整体）", "单商户投入（整体）"];
    //     sample.data = [["128.41497748946097", "4548.841094599493"]];
    // }

    // if (question == "谁负责的项目数最多，列出top5") {
    //     sample.header = ["负责部门", "营销项目编号(去重统计)"];
    //     sample.data = [
    //     [
    //       "张有怡",
    //       "7"
    //     ],
    //     [
    //       "林宇",
    //       "6"
    //     ],
    //     [
    //       "郭令玲",
    //       "6"
    //     ],
    //     [
    //       "欧阳旻",
    //       "4"
    //     ],
    //     [
    //       "周昀",
    //       "3"
    //     ]
    //   ];
    // }

    let data = {
        questionId:"",
        content:"",
        params:[],
        sample:null
    }

    if (question == "今年营销项目带来多少收入") {
        data.content = "为您查询：项目启动时间${filterValue1}的收入${filterValue3}为636181.6320754716552286";
        data.params = [
            {name:"filterValue1", display:"大于等于2025-01-01"},
            {name:"filterValue2", display:"123"},
            {name:"filterValue3", display:"营销项目金额"},
        ];
    }

    /**----------------test */

    let aiAnswerType = AIANSWERTYPE.表格;
    let aiAnswerData:any = null;

    let { questionId, content, params, sample } = data;

    if (!sample) {
        let aiAnswerStr = replacePlaceholders(content, params);
        // // 1. 找到最后一个 "为" 的位置
        // let lastWeiIndex = aiAnswerStr.lastIndexOf("为");
        // let beforeWei = "";
        // let afterWei = "";
        // if (lastWeiIndex !== -1) {
        //     // 2. 截取 "为" 前面的部分（不包含"为"）
        //     beforeWei = aiAnswerStr.slice(0, lastWeiIndex);
        //     // 3. 截取 "为" 后面的部分（不包含"为"）
        //     afterWei = aiAnswerStr.slice(lastWeiIndex + 1); // +1 跳过 "为" 字
        // }
        aiAnswerType = AIANSWERTYPE.文本;
        aiAnswerData = aiAnswerStr;
    } else if (!Object.keys(sample).length) {
        throw new SysError(SYSTEMERRORENUM.未按接口协议返回, interfaceName, "sample 为空", sample);
    } else {
        if (!Array.isArray(sample.header)) throw new SysError(SYSTEMERRORENUM.未按接口协议返回, interfaceName, "sample.header 不是数组", sample);
        if (!Array.isArray(sample.data)) throw new SysError(SYSTEMERRORENUM.未按接口协议返回, interfaceName, "sample.data 不是数组", sample);

        /**
         * 判断逻辑：
         * 1、键值对条件（满足任一）：
         *    - header长度为1 且 data为单行单列
         *    - data为单行多列（适合展示为多个键值对）
         * 2、图表条件：
         *    - header长度为2 且 data为多行，且第二列为数值
         * 3、默认表格展示
         */
        
        if (!sample.header || !sample.data) aiAnswerType = AIANSWERTYPE.键值对;

        // 键值对条件：单行数据
        if (sample.data.length === 1) {
            aiAnswerType = AIANSWERTYPE.键值对;
            aiAnswerData = getKeyValue(sample.header, sample.data);
        }
        // 图表条件：多行数据且第二列为数值
        else if (sample.header.length === 2 && sample.data.every( row => !isNaN(parseFloat(row[1])) )) {
            // 优先检查时间字段
            if (isDateField(sample.header[0])) {
                aiAnswerType = AIANSWERTYPE.折线图;
            } else {
                aiAnswerType = AIANSWERTYPE.柱状图;
            }
            aiAnswerData = getChartData(sample.header, sample.data);
        }
        // 默认表格展示
        else {
            aiAnswerData = getTableData(sample.header, sample.data);
        }
    }

    return { aiAnswerType, aiAnswerData };
}


function replacePlaceholders(content, params) {
    // 使用正则表达式匹配所有${...}的占位符
    return content.replace(/\$\{(\w+)\}/g, (match, paramName) => {
        // 在params数组中查找name匹配的参数
        const param = params.find(p => p.name === paramName);
        // 如果找到则返回display值，否则保持原样
        return param ? param.display : match;
    });
}


function isDateField(headerName) {
    // 简单检查header名称是否包含日期相关词汇
    const dateKeywords = ['日期', '时间', 'day', 'date', 'month', 'year'];
    return dateKeywords.some(keyword => 
        headerName.toLowerCase().includes(keyword.toLowerCase())
    );
}


function getKeyValue(header, data) {
    let keyvalue = [];
    for (let i = 0; i < header.length; i++) {
        keyvalue.push({key: header[i], value:data[0][i]})
    }

    return keyvalue;
}


function getTableData(header, data) {
    let tableData = {handerList:header, bodyList:data};
    return tableData;
}


function getChartData(header, data) {
    let chartData = [];

    for (let i = 0; i < data.length; i++) {
        chartData.push({key: data[i][0], value:data[i][1]})
    }

    return chartData;
}




