import {abstractDataStrategyRight} from "./abstractDataStrategyRight";
import excelSerialToJSDate from "../../../util/excelDateToJSDate";
import getRandomNumber from "../../../util/randomNumberGenerator";
import mapToObj from "../../../util/mapToObj";

export class eventProcessingTimeStrategy extends abstractDataStrategyRight {
    execute(params?: any): any {
        this.paramsCheck(params);
        return mapToObj(this.getEventProcessingTime(this.eventData, params.query.year));
    }

    private getEventProcessingTime(data: any, year: number) {
        const statusList = ['调度时长', '处置等待', '处置时长', '办结时长']
        const timeMap = this.registerItems(statusList);
        let assignCount = 0, waitCount = 0, processCount = 0, finishingCount = 0;

        data.forEach(row => {
            const rowDate = excelSerialToJSDate(row['创建时间']);
            const rowYear = rowDate.getFullYear();
            let waitTime, processTime, closeTime;
            if (rowYear == year) {
                switch (row['处置状态']) {
                    case '待调度':
                        const time = getRandomNumber(0.5, 1.7, 1);
                        timeMap.set('调度时长', timeMap.get('调度时长') + time);
                        assignCount++;
                    case '处置中':
                        waitTime = this.calculateTimeDifference(row['处置时间'], row['创建时间']);
                        if (isNaN(row['处置时间'])) {
                            waitTime = 0;
                            waitCount--;
                        }
                        timeMap.set('处置等待', timeMap.get('处置等待') + waitTime);
                        waitCount++;
                    case '已处置':
                        waitTime = this.calculateTimeDifference(row['处置时间'], row['创建时间']);
                        processTime = this.calculateTimeDifference(row['处置完成时间'], row['处置时间']);
                        if (isNaN(row['处置时间'])) {
                            waitTime = 0;
                            waitCount--;
                        }
                        if (isNaN(row['处置完成时间'])) {
                            processTime = 0;
                            processCount--;
                        }
                        timeMap.set('处置等待', timeMap.get('处置等待') + waitTime);
                        timeMap.set('处置时长', timeMap.get('处置时长') + processTime);
                        waitCount++;
                        processCount++;
                    case '已办结':
                        waitTime = this.calculateTimeDifference(row['处置时间'], row['创建时间']);
                        processTime = this.calculateTimeDifference(row['处置完成时间'], row['处置时间']);
                        closeTime = this.calculateTimeDifference(row['办结时间'], row['创建时间']);
                        if (isNaN(row['处置时间'])) {
                            waitTime = 0;
                            waitCount--;
                        }
                        if (isNaN(row['处置完成时间'])) {
                            processTime = 0;
                            processCount--;
                        }
                        if (isNaN(row['办结时间'])) {
                            closeTime = 0;
                            finishingCount--;
                        }
                        timeMap.set('处置等待', timeMap.get('处置等待') + waitTime);
                        timeMap.set('处置时长', timeMap.get('处置时长') + processTime);
                        timeMap.set('办结时长', timeMap.get('办结时长') + processTime);
                        waitCount++;
                        processCount++;
                        finishingCount++;
                }
            }
        });

        timeMap.set('调度时长', timeMap.get('调度时长') / assignCount);
        timeMap.set('处置等待', timeMap.get('处置等待') / waitCount);
        timeMap.set('处置时长', timeMap.get('处置时长') / processCount);
        timeMap.set('办结时长', timeMap.get('办结时长') / finishingCount);
        return timeMap

    }

    private calculateTimeDifference(start: number, end: number): number {
        const time = excelSerialToJSDate(start).getTime() - excelSerialToJSDate(end).getTime();
        return time / (1000 * 60);
    }
}