import {abstractDataStrategyRight} from "./abstractDataStrategyRight";
import mapToObj from "../../../util/mapToObj";
import excelSerialToJSDate from "../../../util/excelDateToJSDate";

export class eventMonthDistributionStrategy extends abstractDataStrategyRight {
    execute(params?: any): any{
        this.paramsCheck(params);
        return mapToObj(this.getEventMonthDistribution(this.eventData, params.query.year));
    }

    private getEventMonthDistribution(data: any, year: number) {
        const eventCount: Map<number, number> = new Map();
        for (let month = 1; month <= 12; month++) {
            eventCount.set(month, 0);
        }

        data.forEach(row => {
            const rowDate = excelSerialToJSDate(row['创建时间']);
            rowDate.setHours(rowDate.getHours() - eventMonthDistributionStrategy.TIMEDIFFERENCE);
            const rowYear = rowDate.getFullYear();
            const rowMonth = rowDate.getMonth();

            if (rowYear == year) {
                eventCount.set(rowMonth + 1, eventCount.get(rowMonth + 1) + 1);
            }
        });
        return eventCount;

    }
}