import {abstractDataStrategyMid} from "./abstractDataStrategyMid";
import excelSerialToJSDate from "../../../util/excelDateToJSDate";

export class allEventDataStrategy extends abstractDataStrategyMid {
    static readonly RELEVANTINFO = ['事件标题', '处置状态', '数据更新时间', '事件类型', '事件子类型', '事件来源'];

    execute(): any {
        let eventData = this.extractor.getData(allEventDataStrategy.fileName, allEventDataStrategy.sheetName);
        this.removeUnusedColumns(eventData);
        return eventData;
    }

    private removeUnusedColumns(data: any) {
        data.forEach(row => {
            Object.keys(row).forEach(key => {
                if (!allEventDataStrategy.RELEVANTINFO.includes(key)) {
                    delete row[key];
                }
                if (key === '数据更新时间') {
                    row[key] = excelSerialToJSDate(row[key]);
                }
            });
        });
    }
}