import {abstractDataStrategyMid} from "./abstractDataStrategyMid";
import excelSerialToJSDate from "../../../util/excelDateToJSDate";
import mapToObj from "../../../util/mapToObj";

export class currentEventStrategy extends abstractDataStrategyMid {
    execute(params?: any): any {
        if (!params || !params.query || !params.query.date) {
            throw new Error("Date parameter is required.")
        }
        let dayData = this.extractor.getData(currentEventStrategy.fileName, currentEventStrategy.sheetName);
        return mapToObj(this.getCurrentDayEventDate(dayData, params.query.date));
    }

    private getCurrentDayEventDate(data: any, date: string) {
        const eventCount: Map<string, number> = new Map();
        eventCount.set('pendingEvents', 0);
        eventCount.set('processedEvents', 0);


        data.forEach(row => {
            const rowDate = excelSerialToJSDate(row['数据更新时间']);
            let rowDateString = '';
            try {
                rowDateString = rowDate.toISOString().split('T')[0];
            }
            catch (e) {
                rowDateString = 'invalid time'
            }
            if (rowDateString === date) {
                if (row['处置状态'] == '待调度' || row['处置状态'] == '处置中') {
                    eventCount.set('pendingEvents', eventCount.get('pendingEvents') + 1);
                }
                else {
                    eventCount.set('processedEvents', eventCount.get('processedEvents') + 1);
                }
            }
        });

        return eventCount;
    }

}