import excelSerialToJSDate from "../../../util/excelDateToJSDate";
import mapToObj from "../../../util/mapToObj";
import {abstractDataStrategyLeft} from "./abstractDataStrategyLeft";

export class sightVisitorFlowByHourStrategy extends abstractDataStrategyLeft {

    execute(params?: any): any {
        if (!params || !params.query || !params.query.date || !params.query.sight) {
            throw new Error('Date and sight parameters are required.');
        }
        const sightData = this.extractor.getData(sightVisitorFlowByHourStrategy.FILENAME, sightVisitorFlowByHourStrategy.SHEETNAME);
        return mapToObj(this.getVisitorFlowByHour(sightData, params.query.sight, params.query.date));
    }

    private getVisitorFlowByHour(data: any, sight: string, date: string) {
        const visitorCount: Map<number, number> = new Map();
        for (let hour = 0; hour < 24; hour++) {
            visitorCount.set(hour, 0);
        }

        data.forEach(row => {
            const rowDate = excelSerialToJSDate(row['游玩时间']);
            let rowDateString = '';
            try {
                rowDateString = rowDate.toISOString().split('T')[0];
            }
            catch (e) {
                rowDateString = 'invalid time';
            }
            const rowSight = row['景点名称'];
            rowDate.setHours(rowDate.getHours() - sightVisitorFlowByHourStrategy.TIMEDIFFERENCE);
            const rowHour = rowDate.getHours();

            if (rowDateString == date && rowSight == sight) {
                visitorCount.set(rowHour, (visitorCount.get(rowHour) || 0) + 1);
            }
        });
        return visitorCount;
    }
}
