import { randomStatusGenerator } from "../../../util/randomStatusGenerator";
import excelSerialToJSDate from "../../../util/excelDateToJSDate";
import {abstractDataStrategyLeft} from "./abstractDataStrategyLeft";

export class sightVisitorFlowByDayStrategy extends abstractDataStrategyLeft {
    execute(params?: any): any {
        if (!params || !params.query || !params.query.date) {
            throw new Error("Date parameter is required.")
        }
        let sightData = this.extractor.getData(sightVisitorFlowByDayStrategy.FILENAME, sightVisitorFlowByDayStrategy.SHEETNAME);
        return this.getVisitorFlowByDay(sightData, params.query.date);
    }

    private getVisitorFlowByDay(data: any, date: string) {
        const visitorCount: { [sight: string]: { count: number, status: string } } = {};
        data.forEach(row => {
            const rowDate = excelSerialToJSDate(row['游玩时间']);
            let rowDateString = '';
            try {
                rowDateString = rowDate.toISOString().split('T')[0];
            }
            catch (e) {
                rowDateString = 'invalid time'
            }
            const sight = row['景点名称'];

            if (rowDateString == date) {
                if (!visitorCount[sight]) {
                    visitorCount[sight] = {count: 0, status: randomStatusGenerator.getRandomStatus()};
                }
                visitorCount[sight].count++;
            }
        });
        return visitorCount;

    }

}

