import { randomStatusGenerator } from "../../../util/randomStatusGenerator";
import mapToObj from "../../../util/mapToObj";
import {abstractDataStrategyLeft} from "./abstractDataStrategyLeft";

export class gateStatusStrategy extends abstractDataStrategyLeft {
    private gateStatusMap: Map<string, string> = new Map();
    constructor() {
        super();
        this.gateStatusMap.set('south', '');
        this.gateStatusMap.set('east', '');
        this.gateStatusMap.set('west', '');
        this.gateStatusMap.set('north', '');
    }
    execute(): any {
        this.gateStatusMap.forEach((value, key, map) => {
            map.set(key, randomStatusGenerator.getRandomStatus());
        });

        return mapToObj(this.gateStatusMap);
    }

    getGateStatusMap() {
        return this.gateStatusMap;
    }

}