import {abstractDataStrategyLeft} from "./abstractDataStrategyLeft";
import paramChecker from "../../../../util/paramChecker";
import excelSerialToJSDate from "../../../../util/excelDateToJSDate";

export default class sightVisitorRankStrategy extends abstractDataStrategyLeft {
    static readonly FILENAME = '票务系统.xlsx';
    static readonly SHEETNAME = '票务系统-订单主表';

    execute(params?: any): any {
        paramChecker.checkDiscreteParam(params, 'timeFrame', '12month', '3year');
        const data = this.extractor.getData(sightVisitorRankStrategy.FILENAME, sightVisitorRankStrategy.SHEETNAME);
        return this.processData(data, params.query['timeFrame']);
    }

    processData(data: any, timeFrame: string): any {
        const currentDate = new Date();
        let startDate = new Date();
        if (timeFrame === '12month') {
            startDate.setFullYear(currentDate.getFullYear() - 1);
        } else if (timeFrame === '3year') {
            startDate.setFullYear(currentDate.getFullYear() - 3);
        }

        const sightCounts: { [key: string]: number } = {};

        data.forEach(row => {
            const rowDate = excelSerialToJSDate(row['游玩时间']);
            if (rowDate >= startDate && rowDate <= currentDate) {
                const sightName = row['景点名称'];
                if (!sightCounts[sightName]) {
                    sightCounts[sightName] = 0;
                }
                sightCounts[sightName] += 1;
            }
        });

        const sortedSights = Object.entries(sightCounts)
            .sort(([, a], [, b]) => b - a)
            .map(([key, value]) => ({ key, value: value.toString() }));

        return sortedSights;
    }
}
