/**
 * currentEventStrategy.ts
 * 该文件定义了当前事件策略的具体实现，获取当前日期事件的计数映射
 */

import { abstractDataStrategyMid } from "./abstractDataStrategyMid";

/**
 * 当前事件策略类，继承自 abstractDataStrategyMid。
 */
export class currentEventStrategy extends abstractDataStrategyMid {

    /**
     * 执行事件数据策略。
     * @param params - 请求参数。
     * @returns 硬编码的事件数据
     */
    execute(params?: any): any {
        return this.getCurrentDayEventData();
    }

    /**
     * 获取当前日期事件的计数映射
     * @return 硬编码的事件数据
     */
    private getCurrentDayEventData(): Array<{ key: string, count: number, YoY: number, MoM: number } > {
        const eventData = [
            {
                key: "今日待处置事件数",
                count: 32,
                YoY: 0.64,
                MoM: 0
            },
            {
                key: "今日已处置事件数",
                count: 580,
                YoY: 0.64,
                MoM: 0
            },
            {
                key: "今日事件处置率",
                count: 94.7,
                YoY: 0.64,
                MoM: 0
            }
        ];

        return eventData;
    }
}
