/**
 * abstractDataStrategyLeft.ts
 * 该文件定义了一个抽象类，用于左侧数据策略的基础实现。
 */

import { dataStrategy } from "../../../dataStrategy";
import { DataExtractor } from "../../../../util/dataExtractor";

/**
 * 抽象数据策略左侧类，所有具体策略类都需要继承该抽象类。
 */
export abstract class abstractDataStrategyLeft implements dataStrategy {
    // 实例化数据提取器
    extractor = DataExtractor.getInstance();
    static readonly FILENAME = '票务系统.xlsx';
    static readonly SHEETNAME = '票务系统-订单主表';
    static readonly TIMEDIFFERENCE = 8;

    /**
     * 执行策略的方法，具体实现由子类提供。
     * @param params - 可选参数。
     */
    abstract execute(params?: any): any;
}
