import {gateStatusStrategy} from "../biz/map1/strategies/left/gateStatusStrategy";
import {guchengLoadStrategy} from "../biz/map1/strategies/left/guchengLoadStrategy";
import {DataExtractor} from "../util/dataExtractor";
import {sightVisitorFlowByDayStrategy} from "../biz/map1/strategies/left/sightVisitorFlowByDayStrategy";
import {sightVisitorFlowByHourStrategy} from "../biz/map1/strategies/left/sightVisitorFlowPerHourStrategy";
import {totalVisitorFlowByHourStrategy} from "../biz/map1/strategies/left/totalVisitorFlowByHourStrategy";
import {totalVisitorFlowStrategy} from "../biz/map1/strategies/left/totalVisitorFlowStrategy";
import {testDateError, testSightError, testStrategy} from "./utils";

describe('gateStatusTest', () => {
    const de = DataExtractor.getInstance();
    it('should be of size 4', () => {
        const strategy = new gateStatusStrategy();
        strategy.execute();
        expect(strategy.getGateStatusMap().size).toBe(4);
    });


    it('status should be one of 正常, 拥挤, 顺畅', ()=>{
        const strategy = new gateStatusStrategy();
        strategy.execute();
        expect(strategy.getGateStatusMap().forEach((value, key) => {
            expect(value).toMatch(/正常|拥挤|顺畅/);
        }));
    });
});

describe('guchengLoadTest', ()=> {
    it('load should be one of 正常, 拥挤, 顺畅', () => {
        const strategy = new guchengLoadStrategy();
        expect(strategy.execute()).toMatch(/正常|拥挤|顺畅/);
    });
});

describe('sightVisitorFlowByDay test', () => {
    const strategy = new sightVisitorFlowByDayStrategy();
    it('should throw an error if date parameter is missing', () => {
        testDateError(strategy);
    });

    it('should return the correct values', () => {
        const mockParams = {
            query: {
                date: '2023-07-01'
            }
        };
        const truthValue = {
            "八公山森林公园": 8,
            "孔庙": 3,
            "安丰塘（芍跛）": 4,
            "安徽楚文化博物馆": 5,
            "安徽第一面党旗纪念园": 6,
            "寿州古城游客中心": 6,
            "报恩寺": 7,
            "楚玉阁": 3,
            "汐熙阁": 6,
            "清真寺": 5,
            "珍珠泉": 6,
            "迎辉茶馆": 4,
            "随缘堂（周易）": 4
        }

        const res = strategy.execute(mockParams);
        const actualData = {};
        for (const key in res) {
            if (res.hasOwnProperty(key)) {
                actualData[key] = res[key].count;
            }
        }
        expect(actualData).toEqual(truthValue);
    });
});

describe('sightVisitorFlowByHour test', () => {
    const strategy = new sightVisitorFlowByHourStrategy();
    it('should throw an error if date and sight parameters are missing', () => {
        testSightError(strategy);
    });

    it('should return the correct value', ()=> {
        const mockParams = {
            query: {
                date: '2023-07-01',
                sight: '安徽第一面党旗纪念园'
            }
        };
        const truthValue = {
            '0': 0,
            '1': 0,
            '2': 0,
            '3': 0,
            '4': 0,
            '5': 1,
            '6': 0,
            '7': 0,
            '8': 0,
            '9': 1,
            '10': 0,
            '11': 2,
            '12': 0,
            '13': 0,
            '14': 0,
            '15': 0,
            '16': 0,
            '17': 0,
            '18': 0,
            '19': 0,
            '20': 1,
            '21': 1,
            '22': 0,
            '23': 0
        };
        testStrategy(strategy, mockParams, truthValue);
    });
})

describe('totalVisitorFlowByHour test', ()=> {
    const strategy = new totalVisitorFlowByHourStrategy();
    it('should throw an error if date parameter is missing', () => {
        testDateError(strategy);
    });

    it('should get the correct values', () => {
        const mockParams = {
            query: {
                date: '2023-07-01',
            }
        };
        const truthValue = {
            "0": 1,
            "1": 2,
            "2": 2,
            "3": 3,
            "4": 1,
            "5": 2,
            "6": 3,
            "7": 3,
            "8": 4,
            "9": 4,
            "10": 1,
            "11": 3,
            "12": 2,
            "13": 2,
            "14": 3,
            "15": 4,
            "16": 6,
            "17": 5,
            "18": 2,
            "19": 4,
            "20": 4,
            "21": 3,
            "22": 1,
            "23": 2
        }
        testStrategy(strategy, mockParams, truthValue);
    })
});

describe('totalVisitorFlow test',  () => {
    const strategy = new totalVisitorFlowStrategy();
    it('should throw an error if date parameter is missing', () => {
        testDateError(strategy);
    });

    it('should return the right result', () => {
        const mockParams = {
            query: {
                date: '2023-07-01',
            }
        };
        const truthValue = {
            total: 67,
            '老人':19,
            '学生': 13,
            '儿童': 22,
            '其他': 13
        }
        testStrategy(strategy, mockParams, truthValue);
    })

});