export default function excelSerialToJSDate(serial: number): Date {
    const EXCEL_EPOCH = 25569;
    const MS_PER_DAY = 86400000;

    // Split the excelDate into integer and fractional parts
    const days = Math.floor(serial);
    const fractionalDay = serial - days;

    // Convert to milliseconds
    const jsDateMilliseconds = (days - EXCEL_EPOCH) * MS_PER_DAY + fractionalDay * MS_PER_DAY;

    return new Date(jsDateMilliseconds);
}