import {dataStrategy} from "./dataStrategy";

import {sightVisitorFlowByDayStrategy} from "./left/sightVisitorFlowByDayStrategy";
import {gateStatusStrategy} from "./left/gateStatusStrategy";
import {sightVisitorFlowByHourStrategy} from "./left/sightVisitorFlowPerHourStrategy";
import {guchengLoadStrategy} from "./left/guchengLoadStrategy";
import {totalVisitorFlowStrategy} from "./left/totalVisitorFlowStrategy";
import {totalVisitorFlowByHourStrategy} from "./left/totalVisitorFlowByHourStrategy";

import {currentEventStrategy} from "./middle/currentEventStrategy";
import {totalEventCountStrategy} from "./middle/totalEventCountStrategy";
import {allEventDataStrategy} from "./middle/eventDataStrategy";

import {getEventCountByYearStrategy} from "./right/getEventCountByYearStrategy";
import {eventTimeDistributionStrategy} from "./right/eventTimeDistributionStrategy";
import {eventMonthDistributionStrategy} from "./right/eventMonthDistributionStrategy";
import {eventCategoryCountStrategy} from "./right/eventCategoryCountStrategy";
import {eventSubCategoryCountStrategy} from "./right/eventSubCategoryCountStrategy";
import {eventSrcStrategy} from "./right/eventSrcStrategy";
import {gridEventCountStrategy} from "./right/gridEventCountStrategy";
import {eventProcessingTimeStrategy} from "./right/eventProcessingTimeStrategy";

export class strategyFactory {
    private static strategies: { [key: string]: new () => dataStrategy } = {
        'allEvents': allEventDataStrategy,
        'sightVisitorFlowByDay': sightVisitorFlowByDayStrategy,
        'gateStatus': gateStatusStrategy,
        'sightVisitorFlowPerHour': sightVisitorFlowByHourStrategy,
        'guchengLoad': guchengLoadStrategy,
        'totalVisitorFlow': totalVisitorFlowStrategy,
        'totalVisitorFlowByDay': totalVisitorFlowByHourStrategy,
        'currentEventStrategy': currentEventStrategy,
        'totalEventCount': totalEventCountStrategy,
        'getEventCountByYear': getEventCountByYearStrategy,
        'getEventTimeDistribution': eventTimeDistributionStrategy,
        'getEventMonthDistribution': eventMonthDistributionStrategy,
        'getEventCategoryCount': eventCategoryCountStrategy,
        'getEventSubCategoryCount': eventSubCategoryCountStrategy,
        'getEventSourceCount': eventSrcStrategy,
        'getGridEventCount': gridEventCountStrategy,
        'getEventProcessingTime': eventProcessingTimeStrategy,
    };

    static createStrategy(type: string): dataStrategy {
        const StrategyClass = this.strategies[type];
        if (!StrategyClass) {
            throw new Error('Invalid strategy type.');
        }
        return new StrategyClass();
    }

    static registerStrategy(type: string, strategy: new () => dataStrategy) {
        this.strategies[type] = strategy;
    }

}