import {abstractDataStrategyRight} from "./abstractDataStrategyRight";
import excelSerialToJSDate from "../../../util/excelDateToJSDate";
import mapToObj from "../../../util/mapToObj";

export class getEventCountByYearStrategy extends abstractDataStrategyRight {
    execute(params?: any): any {
        this.paramsCheck(params);
        return mapToObj(this.getEventCountForYear(this.eventData, params.query.year));
    }

    private getEventCountForYear(data: any, year: number) {
        const eventList = ['事件总数', '历史遗留', '办结率'];
        const eventCount = this.registerItems(eventList);

        let finishedEventCount = 0;

        data.forEach(row => {
            const rowDate = excelSerialToJSDate(row['创建时间']);
            let rowYear;
            try {
                rowYear = rowDate.getFullYear();
            } catch (e) {
                rowYear = 0;
            }
            if (rowYear == year) {
                eventCount.set('事件总数', eventCount.get('事件总数') + 1);
                if (row['处置状态'] == '已办结') {
                    finishedEventCount++;
                }
            }
            else if (rowYear == year - 1 && row['处置状态'] != '已办结') {
                eventCount.set('历史遗留', eventCount.get('历史遗留') + 1);
            }
        });
        eventCount.set('办结率', finishedEventCount / eventCount.get('事件总数'));
        return eventCount;
    }
}