import {abstractDataStrategyRight} from "./abstractDataStrategyRight";
import excelSerialToJSDate from "../../../util/excelDateToJSDate";
import mapToObj from "../../../util/mapToObj";

export class eventTimeDistributionStrategy extends abstractDataStrategyRight {
    execute(params?: any): any{
        this.paramsCheck(params);
        return mapToObj(this.getEventTimeDistribution(this.eventData, params.query.year));
    }

    private getEventTimeDistribution(data: any, year: number) {
        const eventCount: Map<number, number> = new Map();
        for (let hour = 0; hour < 24; hour++) {
            eventCount.set(hour, 0);
        }

        data.forEach(row => {
            const rowDate = excelSerialToJSDate(row['创建时间']);
            rowDate.setHours(rowDate.getHours() - eventTimeDistributionStrategy.TIMEDIFFERENCE);
            const rowHour = rowDate.getHours()
            const rowYear = rowDate.getFullYear();
            if (rowYear == year) {
                eventCount.set(rowHour, (eventCount.get(rowHour) || 0) + 1);
            }
        });
        return eventCount;
    }
}